/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.javascript.IJavascriptCompressor;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.TextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagedTextTemplate
extends TextTemplate {
    private static final Logger log = LoggerFactory.getLogger(PackagedTextTemplate.class);
    private static final long serialVersionUID = 1L;
    private static final MetaDataKey<TextTemplateCache> TEXT_TEMPLATE_CACHE_KEY = new MetaDataKey<TextTemplateCache>(){
        private static final long serialVersionUID = 1L;
    };
    private final StringBuffer buffer = new StringBuffer();

    public PackagedTextTemplate(Class<?> clazz, String fileName) {
        this(clazz, fileName, "text");
    }

    public PackagedTextTemplate(Class<?> clazz, String fileName, String contentType) {
        this(clazz, fileName, contentType, null);
    }

    public PackagedTextTemplate(Class<?> clazz, String fileName, String contentType, String encoding) {
        super(contentType);
        String path = Packages.absolutePath(clazz, fileName);
        Application app = Application.get();
        app.getMetaData(TEXT_TEMPLATE_CACHE_KEY);
        IResourceStream stream = app.getResourceSettings().getResourceStreamLocator().locate(clazz, path);
        if (stream == null) {
            stream = new ResourceStreamLocator().locate(clazz, path);
        }
        if (stream == null) {
            throw new IllegalArgumentException("resource " + fileName + " not found for scope " + clazz + " (path = " + path + ")");
        }
        try {
            if (encoding != null) {
                this.buffer.append(Streams.readString(stream.getInputStream(), encoding));
            } else {
                this.buffer.append(Streams.readString(stream.getInputStream()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceStreamNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getString() {
        IJavascriptCompressor compressor = Application.get().getResourceSettings().getJavascriptCompressor();
        if (compressor != null) {
            return compressor.compress(this.buffer.toString());
        }
        return this.buffer.toString();
    }

    @Override
    public final TextTemplate interpolate(Map<String, Object> variables) {
        if (variables != null) {
            String result = new MapVariableInterpolator(this.buffer.toString(), variables).toString();
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(result);
        }
        return this;
    }

    private static final class TextTemplateCache
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<CachedTextTemplateKey, CachedTextTemplate> cache = new ConcurrentHashMap<CachedTextTemplateKey, CachedTextTemplate>();

        private TextTemplateCache() {
        }

        CachedTextTemplate get(CachedTextTemplateKey key) {
            return this.cache.get(key);
        }

        void put(CachedTextTemplateKey key, CachedTextTemplate value) {
            this.cache.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachedTextTemplateKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String className;

        CachedTextTemplateKey(Class<?> clazz, String path) {
            this.className = clazz.getName();
        }
    }

    private static final class CachedTextTemplate
    implements Serializable {
        private static final long serialVersionUID = 1L;

        CachedTextTemplate(String text) {
        }
    }
}

