/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.resource;

import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentResourceRequestTarget
implements IRequestTarget {
    private static final Logger log = LoggerFactory.getLogger(ComponentResourceRequestTarget.class);
    private final Page page;
    private final Component component;
    private final RequestListenerInterface listener;

    public ComponentResourceRequestTarget(Page page, Component component, RequestListenerInterface listener) {
        this.page = page;
        this.component = component;
        this.listener = listener;
    }

    public void respond(RequestCycle requestCycle) {
        try {
            this.listener.getMethod().invoke((Object)this.component, new Object[0]);
        }
        catch (Exception e) {
            Response response = requestCycle.getResponse();
            if (response instanceof WebResponse) {
                ((WebResponse)response).getHttpServletResponse().setStatus(500);
                log.error("error handling resource request for component " + this.component + ", on page " + this.page + ", listener " + this.listener.getName() + " - " + e.getMessage(), (Throwable)e);
                return;
            }
            throw new WicketRuntimeException("method " + this.listener.getName() + " of " + this.listener.getMethod().getDeclaringClass() + " targetted at component " + this.component + " threw an exception", e);
        }
    }

    public void detach(RequestCycle requestCycle) {
        this.page.detach();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentResourceRequestTarget) {
            ComponentResourceRequestTarget that = (ComponentResourceRequestTarget)obj;
            return this.page.equals(that.page) && this.component.equals(that.component);
        }
        return false;
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result += this.page.hashCode();
        return 17 * (result += this.component.hashCode());
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append(this.page).append("->").append(this.component.getId()).append("->IResourceListener");
        return b.toString();
    }
}

