/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.resource.ISharedResourceRequestTarget;
import org.apache.wicket.request.target.resource.SharedResourceRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedSharedResourceCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    private final String resourceKey;

    public IndexedSharedResourceCodingStrategy(String mountPath, String resourceKey) {
        super(mountPath);
        if (resourceKey == null) {
            throw new IllegalArgumentException("resource key must not be null");
        }
        this.resourceKey = resourceKey;
    }

    @Override
    public CharSequence encode(IRequestTarget requestTarget) {
        if (!(requestTarget instanceof ISharedResourceRequestTarget)) {
            throw new IllegalArgumentException("This encoder can only be used with instances of " + ISharedResourceRequestTarget.class.getName());
        }
        ISharedResourceRequestTarget target = (ISharedResourceRequestTarget)requestTarget;
        AppendingStringBuffer url = new AppendingStringBuffer();
        url.append(this.getMountPath());
        RequestParameters requestParameters = target.getRequestParameters();
        Map<String, ?> params = requestParameters.getParameters();
        if (params != null) {
            String key;
            Object value;
            params = new LinkedHashMap(params);
            int index = 0;
            while (!params.isEmpty() && (value = params.get(key = Integer.toString(index++))) != null) {
                if (value instanceof String[]) {
                    throw new IllegalArgumentException("indexed parameter value must not be an array");
                }
                params.remove(key);
                url.append('/').append(this.urlEncodePathComponent(value.toString()));
            }
            if (!params.isEmpty()) {
                boolean first = true;
                for (Map.Entry<String, ?> arg : params.entrySet()) {
                    String key2 = this.urlEncodeQueryComponent(arg.getKey());
                    Object obj = arg.getValue();
                    if (obj instanceof String[]) {
                        for (String value2 : (String[])obj) {
                            this.appendToQueryString(url, first, key2, value2);
                            first = false;
                        }
                        continue;
                    }
                    this.appendToQueryString(url, first, key2, obj.toString());
                    first = false;
                }
            }
        }
        return url;
    }

    private void appendToQueryString(AppendingStringBuffer url, boolean first, String key, String value) {
        url.append(first ? (char)'?' : '&');
        url.append(key);
        url.append('=');
        url.append(this.urlEncodeQueryComponent(value));
    }

    @Override
    public IRequestTarget decode(RequestParameters requestParameters) {
        if (requestParameters == null) {
            throw new IllegalArgumentException("request parameters must not be null");
        }
        String path = requestParameters.getPath().substring(this.getMountPath().length());
        int startOfQueryString = path.indexOf("?");
        if (startOfQueryString != -1) {
            path = path.substring(0, startOfQueryString);
        }
        ValueMap parameters = this.decodeParameters(path, requestParameters.getParameters());
        requestParameters.setParameters(parameters);
        requestParameters.setResourceKey(this.resourceKey);
        return new SharedResourceRequestTarget(requestParameters);
    }

    @Override
    protected ValueMap decodeParameters(String path, Map<String, ?> queryParameters) {
        ValueMap parameters = new ValueMap((Map<? extends String, ? extends Object>)queryParameters);
        if (!Strings.isEmpty(path)) {
            StringTokenizer tokens = new StringTokenizer(path, "/");
            int index = 0;
            while (tokens.hasMoreTokens()) {
                parameters.add(Integer.toString(index++), tokens.nextToken());
            }
        }
        return parameters;
    }

    @Override
    public boolean matches(IRequestTarget requestTarget) {
        if (!(requestTarget instanceof ISharedResourceRequestTarget)) {
            return false;
        }
        ISharedResourceRequestTarget target = (ISharedResourceRequestTarget)requestTarget;
        return this.resourceKey.equals(target.getRequestParameters().getResourceKey());
    }
}

