/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.documentvalidation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.protocol.http.documentvalidation.Comment;
import org.apache.wicket.protocol.http.documentvalidation.DocumentElement;
import org.apache.wicket.protocol.http.documentvalidation.HtmlDocumentParser;
import org.apache.wicket.protocol.http.documentvalidation.Tag;
import org.apache.wicket.protocol.http.documentvalidation.TextContent;
import org.apache.wicket.util.collections.ArrayListStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocumentValidator {
    private static final Logger log = LoggerFactory.getLogger(HtmlDocumentValidator.class);
    private final List<DocumentElement> elements = new ArrayList<DocumentElement>();
    private boolean skipComments = true;
    private Tag workingTag;

    public void addRootElement(DocumentElement e) {
        this.elements.add(e);
    }

    public boolean isDocumentValid(String document) {
        HtmlDocumentParser parser = new HtmlDocumentParser(document);
        Iterator<DocumentElement> expectedElements = this.elements.iterator();
        ArrayListStack<Iterator<DocumentElement>> iteratorStack = new ArrayListStack<Iterator<DocumentElement>>();
        ArrayListStack<String> tagNameStack = new ArrayListStack<String>();
        boolean end = false;
        boolean valid = true;
        while (!end) {
            int token = parser.getNextToken();
            switch (token) {
                case -1: {
                    return false;
                }
                case 0: {
                    end = true;
                    break;
                }
                case 1: {
                    valid = this.validateComment(expectedElements, parser);
                    if (valid) break;
                    end = true;
                    break;
                }
                case 2: {
                    valid = this.validateTag(expectedElements, parser);
                    if (!valid) {
                        end = true;
                        break;
                    }
                    expectedElements = this.saveOpenTagState(iteratorStack, expectedElements, tagNameStack);
                    break;
                }
                case 3: {
                    valid = this.validateTag(expectedElements, parser);
                    if (valid) {
                        valid = this.checkOpenCloseTag();
                    }
                    if (valid) break;
                    end = true;
                    break;
                }
                case 4: {
                    expectedElements = this.validateCloseTag(tagNameStack, parser, expectedElements, iteratorStack);
                    if (expectedElements != null) break;
                    valid = false;
                    end = true;
                    break;
                }
                case 5: {
                    valid = this.validateText(expectedElements, parser);
                    if (valid) break;
                    end = true;
                }
            }
        }
        return valid;
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    private boolean checkOpenCloseTag() {
        boolean valid = true;
        if (!this.workingTag.getExpectedChildren().isEmpty()) {
            log.error("Found tag <" + this.workingTag.getTag() + "/> was expected to have " + this.workingTag.getExpectedChildren().size() + " child elements");
            valid = false;
        }
        return valid;
    }

    private boolean isNonClosedTag(String tag) {
        tag = this.workingTag.getTag().toLowerCase();
        if (tag.equals("area")) {
            return true;
        }
        if (tag.equals("base")) {
            return true;
        }
        if (tag.equals("basefont")) {
            return true;
        }
        if (tag.equals("bgsound")) {
            return true;
        }
        if (tag.equals("br")) {
            return true;
        }
        if (tag.equals("col")) {
            return true;
        }
        if (tag.equals("frame")) {
            return true;
        }
        if (tag.equals("hr")) {
            return true;
        }
        if (tag.equals("img")) {
            return true;
        }
        if (tag.equals("input")) {
            return true;
        }
        if (tag.equals("isindex")) {
            return true;
        }
        if (tag.equals("keygen")) {
            return true;
        }
        if (tag.equals("link")) {
            return true;
        }
        if (tag.equals("meta")) {
            return true;
        }
        if (tag.equals("param")) {
            return true;
        }
        if (tag.equals("spacer")) {
            return true;
        }
        return tag.equals("wbr");
    }

    private Iterator<DocumentElement> saveOpenTagState(ArrayListStack<Iterator<DocumentElement>> iteratorStack, Iterator<DocumentElement> expectedElements, ArrayListStack<String> tagNameStack) {
        if (!this.isNonClosedTag(this.workingTag.getTag())) {
            iteratorStack.push(expectedElements);
            expectedElements = this.workingTag.getExpectedChildren().iterator();
            tagNameStack.push(this.workingTag.getTag());
        }
        return expectedElements;
    }

    private Iterator<DocumentElement> validateCloseTag(ArrayListStack<String> tagNameStack, HtmlDocumentParser parser, Iterator<DocumentElement> expectedElements, ArrayListStack<Iterator<DocumentElement>> iteratorStack) {
        if (tagNameStack.isEmpty()) {
            log.error("Found closing tag </" + parser.getTag() + "> when there are no " + "tags currently open");
            expectedElements = null;
        } else {
            String expectedTag = tagNameStack.pop();
            if (!expectedTag.equals(parser.getTag())) {
                log.error("Found closing tag </" + parser.getTag() + "> when we expecting " + "the closing tag </" + expectedTag + "> instead");
                expectedElements = null;
            } else if (expectedElements.hasNext()) {
                DocumentElement e = expectedElements.next();
                log.error("Found closing tag </" + parser.getTag() + "> but we were " + "expecting to find another child element: " + e.toString());
                expectedElements = null;
            } else if (iteratorStack.isEmpty()) {
                log.error("Unexpected parsing error");
                expectedElements = null;
            } else {
                expectedElements = iteratorStack.pop();
            }
        }
        return expectedElements;
    }

    private boolean validateComment(Iterator<DocumentElement> expectedElements, HtmlDocumentParser parser) {
        boolean valid = true;
        if (!this.skipComments) {
            if (expectedElements.hasNext()) {
                DocumentElement e = expectedElements.next();
                if (e instanceof Comment) {
                    if (!((Comment)e).getText().equals(parser.getComment())) {
                        log.error("Found comment '" + parser.getComment() + "' does not match " + "expected comment '" + ((Comment)e).getText() + "'");
                        valid = false;
                    }
                } else {
                    log.error("Found comment '" + parser.getComment() + "' was not expected. " + "We were expecting: " + e.toString());
                    valid = false;
                }
            } else {
                log.error("Found comment '" + parser.getComment() + "' was not expected. " + "We were not expecting any more elements within the current tag");
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateTag(Iterator<DocumentElement> expectedElements, HtmlDocumentParser parser) {
        boolean valid = true;
        if (expectedElements.hasNext()) {
            DocumentElement e = expectedElements.next();
            if (e instanceof Tag) {
                this.workingTag = (Tag)e;
                if (!this.workingTag.getTag().equals(parser.getTag())) {
                    log.error("Found tag <" + parser.getTag() + "> does not match " + "expected tag <" + this.workingTag.getTag() + ">");
                    valid = false;
                } else {
                    Map<String, String> actualAttributes = parser.getAttributes();
                    Map<String, String> expectedAttributes = this.workingTag.getExpectedAttributes();
                    for (Map.Entry<String, String> entry : expectedAttributes.entrySet()) {
                        String value;
                        String name = entry.getKey();
                        String pattern = entry.getValue();
                        if (!actualAttributes.containsKey(name)) {
                            log.error("Tag <" + this.workingTag.getTag() + "> was expected to have a '" + name + "' attribute " + "but this was not present");
                            valid = false;
                        }
                        if ((value = actualAttributes.get(name)) == null) {
                            log.error("Attribute " + name + " was expected but not found");
                            valid = false;
                            continue;
                        }
                        if (value.matches(pattern)) continue;
                        log.error("The value '" + value + "' of attribute '" + name + "' of tag <" + this.workingTag.getTag() + "> was expected to match the pattern '" + pattern + "' but it does not");
                        valid = false;
                    }
                    for (String name : this.workingTag.getIllegalAttributes()) {
                        if (!actualAttributes.containsKey(name)) continue;
                        log.error("Tag <" + this.workingTag.getTag() + "> should not have an attributed named '" + name + "'");
                        valid = false;
                    }
                }
            } else {
                log.error("Found tag <" + parser.getTag() + "> was not expected. " + "We were expecting: " + e.toString());
                valid = false;
            }
        } else {
            log.error("Found tag <" + parser.getTag() + "> was not expected. " + "We were not expecting any more elements within the current tag");
            valid = false;
        }
        return valid;
    }

    private boolean validateText(Iterator<DocumentElement> expectedElements, HtmlDocumentParser parser) {
        boolean valid = true;
        if (expectedElements.hasNext()) {
            DocumentElement e = expectedElements.next();
            if (e instanceof TextContent) {
                if (!parser.getText().matches(((TextContent)e).getValue())) {
                    log.error("Found text '" + parser.getText() + "' does not match " + "expected text '" + ((TextContent)e).getValue() + "'");
                    valid = false;
                }
            } else {
                log.error("Found text '" + parser.getText() + "' was not expected. " + "We were expecting: " + e.toString());
                valid = false;
            }
        } else {
            log.error("Found text '" + parser.getText() + "' was not expected. " + "We were not expecting any more elements within the current tag");
            valid = false;
        }
        return valid;
    }
}

