/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IPageMap;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.MockHttpServletRequest;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.MockHttpSession;
import org.apache.wicket.protocol.http.MockServletContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.request.WebErrorCodeResponseTarget;
import org.apache.wicket.request.target.coding.WebRequestEncoder;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.file.WebApplicationPath;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockWebApplication {
    private static final Logger log = LoggerFactory.getLogger(MockWebApplication.class);
    private Page lastRenderedPage;
    private Page previousRenderedPage;
    private final MockHttpServletRequest servletRequest;
    private final MockHttpServletResponse servletResponse;
    private final MockHttpSession servletSession;
    private WebRequest wicketRequest;
    private Map<String, String[]> parametersForNextRequest = new HashMap<String, String[]>();
    private WebResponse wicketResponse;
    private WebSession wicketSession;
    private final WebApplication application;
    private final ServletContext context;
    private final WicketFilter filter;
    private final Set<Cookie> cookiesOfThisSession = new HashSet<Cookie>();
    private boolean createAjaxRequest = false;

    public MockWebApplication(final WebApplication application, String path) {
        this.application = application;
        this.context = this.newServletContext(path);
        this.filter = new WicketFilter(){

            protected IWebApplicationFactory getApplicationFactory() {
                return new IWebApplicationFactory(){

                    public WebApplication createApplication(WicketFilter filter) {
                        return application;
                    }
                };
            }
        };
        try {
            this.filter.init(new FilterConfig(){

                public ServletContext getServletContext() {
                    return MockWebApplication.this.context;
                }

                public Enumeration<?> getInitParameterNames() {
                    return null;
                }

                public String getInitParameter(String name) {
                    if (name.equals("filterMappingUrlPattern")) {
                        return "<servlet>";
                    }
                    return null;
                }

                public String getFilterName() {
                    return "WicketMockServlet";
                }
            });
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        Application.set(this.application);
        this.servletSession = new MockHttpSession(this.context);
        this.servletSession.setTemporary(this.initializeHttpSessionAsTemporary());
        this.servletRequest = new MockHttpServletRequest(this.application, this.servletSession, this.context);
        this.servletResponse = new MockHttpServletResponse(this.servletRequest){

            public void addCookie(Cookie cookie) {
                super.addCookie(cookie);
                Iterator iter = MockWebApplication.this.cookiesOfThisSession.iterator();
                while (iter.hasNext()) {
                    Cookie entry = (Cookie)iter.next();
                    if (!cookie.getName().equals(entry.getName())) continue;
                    iter.remove();
                }
                if (cookie.getMaxAge() != 0) {
                    MockWebApplication.this.cookiesOfThisSession.add(cookie);
                }
            }
        };
        this.wicketRequest = this.application.newWebRequest(this.servletRequest);
        this.wicketResponse = this.application.newWebResponse(this.servletResponse);
        this.createRequestCycle();
        this.application.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.ONE_PASS_RENDER);
        this.application.getRequestCycleSettings().setBufferResponse(false);
        if (this.application.getResourceFinder() == null) {
            this.application.getResourceSettings().setResourceFinder(new WebApplicationPath(this.context));
        }
        this.application.getPageSettings().setAutomaticMultiWindowSupport(false);
        this.application.getResourceSettings().setResourcePollFrequency(null);
    }

    public boolean initializeHttpSessionAsTemporary() {
        return false;
    }

    public ServletContext newServletContext(String path) {
        return new MockServletContext(this.application, path);
    }

    public final WebApplication getApplication() {
        return this.application;
    }

    public Page getLastRenderedPage() {
        return this.lastRenderedPage;
    }

    public Page getPreviousRenderedPage() {
        return this.previousRenderedPage;
    }

    public MockHttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public MockHttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public MockHttpSession getServletSession() {
        return this.servletSession;
    }

    public WebRequest getWicketRequest() {
        return this.wicketRequest;
    }

    public WebResponse getWicketResponse() {
        return this.wicketResponse;
    }

    public WebSession getWicketSession() {
        return this.wicketSession;
    }

    public void processRequestCycle(Component component) {
        this.setupRequestAndResponse();
        WebRequestCycle cycle = this.createRequestCycle();
        cycle.request(component);
        if (component instanceof Page) {
            this.lastRenderedPage = (Page)component;
        }
        this.postProcessRequestCycle(cycle);
    }

    public <C extends Page> void processRequestCycle(Class<C> pageClass) {
        this.processRequestCycle(pageClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Page> void processRequestCycle(Class<C> pageClass, PageParameters params) {
        WebRequestCycle cycle = this.setupRequestAndResponse();
        try {
            BaseWicketTester.callOnBeginRequest(cycle);
            BookmarkablePageRequestTarget requestTarget = new BookmarkablePageRequestTarget(pageClass, params);
            if (pageClass == this.application.getHomePage()) {
                Page currentPage;
                IPageMap pageMap;
                IRequestTarget currentTarget = cycle.getRequestTarget();
                String pageMapName = currentTarget instanceof IPageRequestTarget ? ((pageMap = (currentPage = ((IPageRequestTarget)currentTarget).getPage()).getPageMap()).isDefault() ? "" : pageMap.getName()) : "";
                AppendingStringBuffer buffer = new AppendingStringBuffer(64);
                WebRequestEncoder encoder = new WebRequestEncoder(buffer);
                encoder.addValue("wicket:bookmarkablePage", pageMapName + ':' + pageClass.getName());
                if (params != null) {
                    for (String key : params.keySet()) {
                        String[] values = params.getStringArray(key);
                        if (values == null) continue;
                        for (int i = 0; i < values.length; ++i) {
                            encoder.addValue(key, values[i]);
                        }
                    }
                }
                String url = buffer.toString();
                String path = this.application.getClass().getName();
                path = path.substring(path.lastIndexOf(46) + 1);
                path = "/" + path + "/" + path + "/";
                this.getServletRequest().setURL(path + url);
            } else if (this.application.getHomePage() != null) {
                String url = ((Object)cycle.urlFor(requestTarget)).toString();
                String path = this.application.getClass().getName();
                path = path.substring(path.lastIndexOf(46) + 1);
                path = "/" + path + "/" + path + "/";
                this.getServletRequest().setURL(path + url);
            } else {
                log.warn("The application does not have a HomePage, this might cause problems or unexpected behavior");
            }
            cycle.request(requestTarget);
        }
        finally {
            cycle.getResponse().close();
        }
        this.postProcessRequestCycle(cycle);
    }

    public void processRequestCycle() {
        this.processRequestCycle(this.createRequestCycle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestCycle(WebRequestCycle cycle) {
        try {
            cycle.request();
            if (!cycle.wasHandled()) {
                cycle.setRequestTarget(new WebErrorCodeResponseTarget(404));
            }
            cycle.detach();
            this.createRequestCycle();
        }
        finally {
            cycle.getResponse().close();
        }
        this.postProcessRequestCycle(cycle);
    }

    public final void postProcessRequestCycle(WebRequestCycle cycle) {
        this.previousRenderedPage = this.lastRenderedPage;
        if (cycle.getResponse() instanceof WebResponse) {
            MockHttpServletResponse httpResponse = (MockHttpServletResponse)cycle.getWebResponse().getHttpServletResponse();
            if (httpResponse.isRedirect()) {
                this.lastRenderedPage = this.generateLastRenderedPage(cycle);
                MockHttpServletRequest newHttpRequest = new MockHttpServletRequest(this.application, this.servletSession, this.application.getServletContext());
                newHttpRequest.setRequestToRedirectString(httpResponse.getRedirectLocation());
                this.wicketRequest = this.application.newWebRequest(newHttpRequest);
                cycle = this.createRequestCycle();
                cycle.request();
            } else {
                String url = httpResponse.getHeader("Ajax-Location");
                if (url != null) {
                    MockHttpServletRequest newHttpRequest = new MockHttpServletRequest(this.application, this.servletSession, this.application.getServletContext());
                    newHttpRequest.setRequestToRedirectString(url);
                    this.wicketRequest = this.application.newWebRequest(newHttpRequest);
                    cycle = this.createRequestCycle();
                    cycle.request();
                }
            }
        }
        this.lastRenderedPage = this.generateLastRenderedPage(cycle);
        Session.set(this.getWicketSession());
        if (this.getLastRenderedPage() instanceof ExceptionErrorPage) {
            throw (RuntimeException)((ExceptionErrorPage)this.getLastRenderedPage()).getThrowable();
        }
    }

    private Page generateLastRenderedPage(WebRequestCycle cycle) {
        Class<? extends Page> responseClass;
        Page newLastRenderedPage = cycle.getResponsePage();
        if (newLastRenderedPage == null && (responseClass = cycle.getResponsePageClass()) != null) {
            Session.set(cycle.getSession());
            IRequestTarget target = cycle.getRequestTarget();
            if (target instanceof IPageRequestTarget) {
                newLastRenderedPage = ((IPageRequestTarget)target).getPage();
            } else if (target instanceof IBookmarkablePageRequestTarget) {
                this.createRequestCycle();
                IBookmarkablePageRequestTarget pageClassRequestTarget = (IBookmarkablePageRequestTarget)target;
                Class<? extends Page> pageClass = pageClassRequestTarget.getPageClass();
                PageParameters parameters = pageClassRequestTarget.getPageParameters();
                newLastRenderedPage = parameters == null || parameters.size() == 0 ? this.application.getSessionSettings().getPageFactory().newPage(pageClass) : this.application.getSessionSettings().getPageFactory().newPage(pageClass, parameters);
            }
        }
        if (newLastRenderedPage == null) {
            newLastRenderedPage = this.lastRenderedPage;
        }
        return newLastRenderedPage;
    }

    public WebRequestCycle createRequestCycle() {
        WebRequestCycle cycle = (WebRequestCycle)this.application.newRequestCycle(this.wicketRequest, this.wicketResponse);
        this.wicketSession = (WebSession)Session.findOrCreate();
        cycle.setAutomaticallyClearFeedbackMessages(false);
        return cycle;
    }

    public WebRequestCycle setupRequestAndResponse(boolean isAjax) {
        this.servletRequest.initialize();
        this.servletResponse.initialize();
        this.servletRequest.addCookies(this.cookiesOfThisSession);
        this.servletRequest.setParameters(this.parametersForNextRequest);
        if (isAjax) {
            this.servletRequest.addHeader("Wicket-Ajax", "Yes");
        }
        this.parametersForNextRequest.clear();
        this.wicketRequest = this.application.newWebRequest(this.servletRequest);
        this.wicketResponse = this.application.newWebResponse(this.servletResponse);
        WebRequestCycle requestCycle = this.createRequestCycle();
        if (!this.initializeHttpSessionAsTemporary()) {
            this.application.getSessionStore().bind(this.wicketRequest, this.wicketSession);
        }
        this.wicketResponse.setAjax(this.wicketRequest.isAjax());
        this.createAjaxRequest = false;
        return requestCycle;
    }

    public WebRequestCycle setupRequestAndResponse() {
        return this.setupRequestAndResponse(this.isCreateAjaxRequest());
    }

    public Map<String, String[]> getParametersForNextRequest() {
        return this.parametersForNextRequest;
    }

    public void setParametersForNextRequest(Map<String, String[]> parametersForNextRequest) {
        this.parametersForNextRequest = parametersForNextRequest;
    }

    public void destroy() {
        this.filter.destroy();
        File dir = (File)this.context.getAttribute("javax.servlet.context.tempdir");
        this.deleteDir(dir);
        this.application.internalDestroy();
    }

    private void deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File element = files[i];
                    if (element.isDirectory()) {
                        this.deleteDir(element);
                        continue;
                    }
                    element.delete();
                }
            }
            dir.delete();
        }
    }

    public boolean isCreateAjaxRequest() {
        return this.createAjaxRequest;
    }

    public void setCreateAjaxRequest(boolean createAjaxRequest) {
        this.createAjaxRequest = createAjaxRequest;
    }
}

