/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.RequestCycle;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadableDetachableModel<T>
implements IModel<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LoadableDetachableModel.class);
    private transient boolean attached = false;
    private transient T transientModelObject;

    public LoadableDetachableModel() {
    }

    public LoadableDetachableModel(T object) {
        this.transientModelObject = object;
        this.attached = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        if (this.attached) {
            try {
                this.onDetach();
            }
            finally {
                this.attached = false;
                this.transientModelObject = null;
                log.debug("removed transient object for {}, requestCycle {}", (Object)this, (Object)RequestCycle.get());
            }
        }
    }

    @Override
    public T getObject() {
        if (!this.attached) {
            this.attached = true;
            this.transientModelObject = this.load();
            if (log.isDebugEnabled()) {
                log.debug("loaded transient object " + this.transientModelObject + " for " + this + ", requestCycle " + RequestCycle.get());
            }
            this.onAttach();
        }
        return this.transientModelObject;
    }

    public final boolean isAttached() {
        return this.attached;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(":attached=").append(this.attached).append(":tempModelObject=[").append(this.transientModelObject).append("]");
        return sb.toString();
    }

    protected abstract T load();

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    @Override
    public void setObject(T object) {
        this.attached = true;
        this.transientModelObject = object;
    }
}

