/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.resources;

import org.apache.wicket.Application;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagedResourceReference
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;

    public PackagedResourceReference(String id, Class<?> referer, String file, String attributeToReplace) {
        this(id, referer, new Model<String>(file), attributeToReplace);
    }

    public PackagedResourceReference(String id, final Class<?> referer, final IModel<String> file, String attributeToReplace) {
        super(id);
        if (referer == null) {
            throw new IllegalArgumentException("Referer may not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        if (attributeToReplace == null) {
            throw new IllegalArgumentException("AttributeToReplace may not be null");
        }
        Model<String> srcReplacement = new Model<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getObject() {
                String str = (String)file.getObject();
                if (str == null) {
                    throw new IllegalArgumentException("The model must provide a non-null object");
                }
                if (!(str instanceof String)) {
                    throw new IllegalArgumentException("The model must provide a string");
                }
                String f = PackagedResourceReference.this.getConverter(String.class).convertToString(str, PackagedResourceReference.this.getLocale());
                ResourceReference ref = new ResourceReference(referer, f, PackagedResourceReference.this.getLocale(), PackagedResourceReference.this.getStyle());
                CharSequence url = PackagedResourceReference.this.urlFor(ref);
                return url != null ? ((Object)url).toString() : null;
            }
        };
        this.add(new AttributeModifier(attributeToReplace, true, srcReplacement));
    }

    protected ResourceReference createPackageResourceReference(Application app, Class<?> scope, String name) {
        ResourceReference resourceReference = new ResourceReference(scope, name);
        resourceReference.bind(app);
        return resourceReference;
    }

    public PackagedResourceReference(String id, ResourceReference resourceReference, String attributeToReplace) {
        this(id, new Model<ResourceReference>(resourceReference), attributeToReplace);
    }

    public PackagedResourceReference(String id, final IModel<ResourceReference> resourceReference, String attributeToReplace) {
        super(id);
        if (resourceReference == null) {
            throw new IllegalArgumentException("ResourceReference may not be null");
        }
        if (attributeToReplace == null) {
            throw new IllegalArgumentException("AttributeToReplace may not be null");
        }
        Model<String> srcReplacement = new Model<String>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getObject() {
                Object o = resourceReference.getObject();
                if (o == null) {
                    throw new IllegalArgumentException("The model must provide a non-null object");
                }
                if (!(o instanceof ResourceReference)) {
                    throw new IllegalArgumentException("The model must provide an instance of ResourceReference");
                }
                ResourceReference ref = (ResourceReference)o;
                CharSequence url = PackagedResourceReference.this.urlFor(ref);
                return url != null ? ((Object)url).toString() : null;
            }
        };
        this.add(new AttributeModifier(attributeToReplace, true, srcReplacement));
    }
}

