/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button
extends FormComponent<String>
implements IFormSubmittingComponent {
    private static final long serialVersionUID = 1L;
    private boolean defaultFormProcessing = true;

    public Button(String id) {
        super(id);
        this.setVersioned(true);
        this.setOutputMarkupId(true);
    }

    public Button(String id, IModel<String> model) {
        super(id, model);
        this.setVersioned(true);
        this.setOutputMarkupId(true);
    }

    protected IModel<String> initModel() {
        return null;
    }

    @Override
    public final boolean getDefaultFormProcessing() {
        return this.defaultFormProcessing;
    }

    public final Button setDefaultFormProcessing(boolean defaultFormProcessing) {
        if (this.defaultFormProcessing != defaultFormProcessing) {
            this.addStateChange(new Change(){
                private static final long serialVersionUID = 1L;
                boolean formerValue;
                {
                    this.formerValue = Button.this.defaultFormProcessing;
                }

                public void undo() {
                    Button.this.defaultFormProcessing = this.formerValue;
                }

                public String toString() {
                    return "DefaultFormProcessingChange[component: " + Button.this.getPath() + ", default processing: " + this.formerValue + "]";
                }
            });
        }
        this.defaultFormProcessing = defaultFormProcessing;
        return this;
    }

    @Override
    public void updateModel() {
    }

    protected String getOnClickScript() {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        try {
            String value = this.getDefaultModelObjectAsString();
            if (value != null && !"".equals(value)) {
                tag.put("value", value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String onClickJavaScript = this.getOnClickScript();
        if (onClickJavaScript != null) {
            tag.put("onclick", onClickJavaScript);
        }
    }

    @Override
    public void onSubmit() {
    }
}

