/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.util.Locale;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSPackageResource
extends PackageResource {
    private static final long serialVersionUID = 1L;

    public static final HeaderContributor getHeaderContribution(final Class<?> scope, final String path) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(new CompressedResourceReference(scope, path));
            }
        });
    }

    public static final HeaderContributor getHeaderContribution(final Class<?> scope, final String path, final String media) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(new CompressedResourceReference(scope, path), media);
            }
        });
    }

    public static final HeaderContributor getHeaderContribution(final ResourceReference reference) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(reference);
            }
        });
    }

    public static final HeaderContributor getHeaderContribution(final ResourceReference reference, final String media) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(reference, media);
            }
        });
    }

    public static final HeaderContributor getHeaderContribution(final String location) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(CSSPackageResource.returnRelativePath(location));
            }
        });
    }

    public static final HeaderContributor getHeaderContribution(final String location, final String media) {
        return new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderCSSReference(CSSPackageResource.returnRelativePath(location), media);
            }
        });
    }

    private static final String returnRelativePath(String location) {
        if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("/")) {
            return location;
        }
        return RequestCycle.get().getProcessor().getRequestCodingStrategy().rewriteStaticRelativeUrl(location);
    }

    protected CSSPackageResource(Class<?> scope, String path, Locale locale, String style) {
        super(scope, path, locale, style);
    }
}

