/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeedbackMessages
implements IClusterable,
Iterable<FeedbackMessage> {
    private static final Logger log = LoggerFactory.getLogger(FeedbackMessages.class);
    private static final long serialVersionUID = 1L;
    private List<FeedbackMessage> messages = new CopyOnWriteArrayList<FeedbackMessage>();

    public final void add(Component reporter, String message, int level) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), level));
    }

    public final int clear() {
        return this.clear(null);
    }

    public final int clear(IFeedbackMessageFilter filter) {
        if (this.messages.size() == 0) {
            return 0;
        }
        List<FeedbackMessage> toDelete = this.messages(filter);
        for (FeedbackMessage message : toDelete) {
            message.detach();
        }
        this.messages.removeAll(toDelete);
        this.trimToSize();
        return toDelete.size();
    }

    public final void debug(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 100));
    }

    public final void error(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 400));
    }

    public final void fatal(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 500));
    }

    public final boolean hasErrorMessageFor(Component component) {
        return this.hasMessageFor(component, 400);
    }

    public final boolean hasMessage(IFeedbackMessageFilter filter) {
        return this.messages(filter).size() != 0;
    }

    public final boolean hasMessageFor(Component component) {
        return this.messageForComponent(component) != null;
    }

    public final boolean hasMessageFor(Component component, int level) {
        for (FeedbackMessage message : this.messages) {
            if (message.getReporter() != component || !message.isLevel(level)) continue;
            return true;
        }
        return false;
    }

    public final void info(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 200));
    }

    public final boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public final Iterator<FeedbackMessage> iterator() {
        return this.messages.iterator();
    }

    public final FeedbackMessage messageForComponent(Component component) {
        for (FeedbackMessage message : this.messages) {
            if (message.getReporter() != component) continue;
            return message;
        }
        return null;
    }

    public final List<FeedbackMessage> messages(IFeedbackMessageFilter filter) {
        if (this.messages.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<FeedbackMessage> list = new ArrayList<FeedbackMessage>();
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            list.add(message);
        }
        return list;
    }

    public final int size() {
        return this.messages.size();
    }

    public final int size(IFeedbackMessageFilter filter) {
        int count = 0;
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "[feedbackMessages = " + StringList.valueOf(this.messages) + "]";
    }

    public final void trimToSize() {
        if (this.messages instanceof ArrayList) {
            ((ArrayList)this.messages).trimToSize();
        }
    }

    public final void warn(Component reporter, String message) {
        this.add(new FeedbackMessage(reporter, (Serializable)((Object)message), 300));
    }

    public final void add(FeedbackMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("Adding feedback message " + message);
        }
        this.messages.add(message);
    }
}

