/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.AbstractRestartResponseException;
import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.RequestParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartResponseAtInterceptPageException
extends AbstractRestartResponseException {
    private static final long serialVersionUID = 1L;

    public RestartResponseAtInterceptPageException(Page interceptPage) {
        if (interceptPage == null) {
            throw new IllegalStateException("Argument interceptPage cannot be null");
        }
        this.redirectToInterceptPage(interceptPage);
    }

    public <C extends Page> RestartResponseAtInterceptPageException(Class<C> interceptPageClass) {
        if (interceptPageClass == null) {
            throw new IllegalStateException("Argument pageClass cannot be null");
        }
        this.redirectToInterceptPage(interceptPageClass);
    }

    private void redirectToInterceptPage(Page interceptPage) {
        Page requestPage = RequestCycle.get().getRequest().getPage();
        IPageMap pageMap = requestPage != null ? requestPage.getPageMap() : interceptPage.getPageMap();
        pageMap.redirectToInterceptPage(interceptPage);
    }

    private <C extends Page> void redirectToInterceptPage(Class<C> interceptPageClass) {
        IPageMap pageMap;
        RequestCycle cycle = RequestCycle.get();
        Page requestPage = cycle.getRequest().getPage();
        if (requestPage != null) {
            pageMap = requestPage.getPageMap();
        } else {
            RequestParameters parameters = cycle.getRequest().getRequestParameters();
            pageMap = PageMap.forName(parameters.getPageMapName());
        }
        pageMap.redirectToInterceptPage(interceptPageClass);
    }
}

