/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.layers;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.RestletException;
import org.geowebcache.util.ServletUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class TileLayerRestlet
extends GWCRestlet {
    private XMLConfiguration xmlConfig;
    private TileLayerDispatcher layerDispatcher;

    public void handle(Request request, Response response) {
        Method met = request.getMethod();
        try {
            if (met.equals((Object)Method.GET)) {
                this.doGet(request, response);
            } else {
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                } else if (met.equals((Object)Method.PUT)) {
                    this.doPut(request, response);
                } else if (met.equals((Object)Method.DELETE)) {
                    this.doDelete(request, response);
                } else {
                    throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                }
                this.layerDispatcher.reInit();
            }
        }
        catch (RestletException re) {
            response.setEntity(re.getRepresentation());
            response.setStatus(re.getStatus());
        }
        catch (Exception e) {
            response.setEntity(e.getMessage() + " " + e.toString(), MediaType.TEXT_PLAIN);
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            e.printStackTrace();
        }
    }

    protected void doGet(Request req, Response resp) throws RestletException {
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        String formatExtension = (String)req.getAttributes().get("extension");
        resp.setEntity(this.doGetInternal(layerName, formatExtension));
    }

    protected Representation doGetInternal(String layerName, String formatExtension) throws RestletException {
        TileLayer tl = TileLayerRestlet.findTileLayer(layerName, this.layerDispatcher);
        if (formatExtension.equalsIgnoreCase("xml")) {
            return this.getXMLRepresentation(tl);
        }
        if (formatExtension.equalsIgnoreCase("json")) {
            return this.getJsonRepresentation(tl);
        }
        throw new RestletException("Unknown or missing format extension : " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
    }

    private void doPost(Request req, Response resp) throws RestletException, IOException, GeoWebCacheException {
        TileLayer tl = this.deserializeAndCheckLayer(req, resp, false);
        if (!this.xmlConfig.modifyLayer(tl)) {
            throw new RestletException("Layer " + tl.getName() + " is not known by the configuration." + "Maybe it was loaded from another source, or you're trying to add a new " + "layer and need to do an HTTP PUT ?", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        this.layerDispatcher.reInit();
    }

    private void doPut(Request req, Response resp) throws RestletException, IOException, GeoWebCacheException {
        TileLayer tl = this.deserializeAndCheckLayer(req, resp, true);
        TileLayer testtl = null;
        try {
            testtl = TileLayerRestlet.findTileLayer(tl.getName(), this.layerDispatcher);
        }
        catch (RestletException re) {
            // empty catch block
        }
        if (testtl != null) {
            throw new RestletException("Layer with name " + tl.getName() + " already exists, " + "use POST if you want to replace it.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        this.xmlConfig.addLayer(tl);
        this.layerDispatcher.reInit();
    }

    private void doDelete(Request req, Response resp) throws RestletException, GeoWebCacheException {
        String layerName = (String)req.getAttributes().get("layer");
        TileLayer tl = TileLayerRestlet.findTileLayer(layerName, this.layerDispatcher);
        this.xmlConfig.deleteLayer(tl);
        this.layerDispatcher.reInit();
    }

    protected TileLayer deserializeAndCheckLayer(Request req, Response resp, boolean isPut) throws RestletException, IOException {
        String layerName = ServletUtils.URLDecode((String)((String)req.getAttributes().get("layer")), (String)"UTF-8");
        String formatExtension = (String)req.getAttributes().get("extension");
        InputStream is = req.getEntity().getStream();
        if (!isPut) {
            TileLayerRestlet.findTileLayer(layerName, this.layerDispatcher);
        }
        return this.deserializeAndCheckLayerInternal(layerName, formatExtension, is);
    }

    protected TileLayer deserializeAndCheckLayerInternal(String layerName, String formatExtension, InputStream is) throws RestletException, IOException {
        XStream xs = this.xmlConfig.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new DomDriver()));
        WMSLayer newLayer = null;
        if (formatExtension.equalsIgnoreCase("xml")) {
            newLayer = (WMSLayer)xs.fromXML(is);
        } else if (formatExtension.equalsIgnoreCase("json")) {
            JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
            HierarchicalStreamReader hsr = driver.createReader(is);
            StringWriter writer = new StringWriter();
            new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
            writer.close();
            newLayer = (WMSLayer)xs.fromXML(writer.toString());
        } else {
            throw new RestletException("Unknown or missing format extension: " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (!newLayer.getName().equals(layerName)) {
            throw new RestletException("There is a mismatch between the name of the  layer in the submission and the URL you specified.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return newLayer;
    }

    public Representation getXMLRepresentation(TileLayer layer) {
        XStream xs = this.xmlConfig.getConfiguredXStream(new XStream());
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xs.toXML((Object)layer);
        return new StringRepresentation((CharSequence)xmlText, MediaType.TEXT_XML);
    }

    public JsonRepresentation getJsonRepresentation(TileLayer layer) {
        JsonRepresentation rep = null;
        try {
            XStream xs = this.xmlConfig.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()));
            JSONObject obj = new JSONObject(xs.toXML((Object)layer));
            rep = new JsonRepresentation(obj);
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
        return rep;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setXMLConfiguration(XMLConfiguration xmlConfig) {
        this.xmlConfig = xmlConfig;
    }
}

