/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalogbuilder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.geotools.console.Option;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogBuilderConfiguration {
    public Hints hints;
    private String timeAttribute;
    private String elevationAttribute;
    private String runtimeAttribute;
    private boolean absolute = false;
    private boolean caching = true;
    private String indexName = "index";
    private String locationAttribute = "location";
    private boolean footprintManagement = true;
    @Option(description="Root directory where to place the index file", mandatory=true, name="rootDirectory")
    private String rootMosaicDirectory;
    @Option(description="Wildcard to use for building the index of this mosaic", mandatory=false, name="wildcard")
    private String wildcard = "*.*";
    private String schema;
    private String propertyCollectors;
    private String envelope2D;
    private String resolutionLevels;
    private boolean recursive = true;
    private List<String> indexingDirectories;

    public String getResolutionLevels() {
        return this.resolutionLevels;
    }

    public void setResolutionLevels(String resolutionLevels) {
        this.resolutionLevels = resolutionLevels;
    }

    public String getEnvelope2D() {
        return this.envelope2D;
    }

    public void setEnvelope2D(String bbox) {
        this.envelope2D = bbox;
    }

    public CatalogBuilderConfiguration() {
    }

    public CatalogBuilderConfiguration(CatalogBuilderConfiguration that) {
        Utilities.ensureNonNull((String)"CatalogBuilderConfiguration", (Object)that);
        try {
            BeanUtils.copyProperties((Object)this, (Object)that);
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
        catch (InvocationTargetException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
    }

    public Hints getHints() {
        return this.hints;
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public void setIndexingDirectories(List<String> indexingDirectories) {
        this.indexingDirectories = indexingDirectories;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public String getPropertyCollectors() {
        return this.propertyCollectors;
    }

    public void setPropertyCollectors(String propertyCollectors) {
        this.propertyCollectors = propertyCollectors;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTimeAttribute() {
        return this.timeAttribute;
    }

    public void setTimeAttribute(String timeAttribute) {
        this.timeAttribute = timeAttribute;
    }

    public boolean isFootprintManagement() {
        return this.footprintManagement;
    }

    public void setFootprintManagement(boolean footprintManagement) {
        this.footprintManagement = footprintManagement;
    }

    public String getElevationAttribute() {
        return this.elevationAttribute;
    }

    public void setElevationAttribute(String elevationAttribute) {
        this.elevationAttribute = elevationAttribute;
    }

    public String getRuntimeAttribute() {
        return this.runtimeAttribute;
    }

    public void setRuntimeAttribute(String runtimeAttribute) {
        this.runtimeAttribute = runtimeAttribute;
    }

    public List<String> getIndexingDirectories() {
        return this.indexingDirectories;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getLocationAttribute() {
        return this.locationAttribute;
    }

    public String getRootMosaicDirectory() {
        return this.rootMosaicDirectory;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setLocationAttribute(String locationAttribute) {
        this.locationAttribute = locationAttribute;
    }

    public void setRootMosaicDirectory(String rootMosaicDirectory) {
        Utilities.ensureNonNull((String)"rootMosaicDirectory", (Object)rootMosaicDirectory);
        String testingDirectory = rootMosaicDirectory;
        Utils.checkDirectory(testingDirectory);
        this.rootMosaicDirectory = testingDirectory;
    }

    public void setWildcard(String wildcardString) {
        this.wildcard = wildcardString;
    }

    public CatalogBuilderConfiguration clone() throws CloneNotSupportedException {
        return new CatalogBuilderConfiguration(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CatalogBuilderConfiguration)) {
            return false;
        }
        CatalogBuilderConfiguration that = (CatalogBuilderConfiguration)obj;
        if (this.absolute != that.absolute) {
            return false;
        }
        if (this.caching != that.caching) {
            return false;
        }
        if (this.recursive != that.recursive) {
            return false;
        }
        if (this.footprintManagement != that.footprintManagement) {
            return false;
        }
        if (!(this.indexName == null && that.indexName == null || this.indexName.equals(that.indexName))) {
            return false;
        }
        if (!(this.locationAttribute == null && that.locationAttribute == null || this.locationAttribute.equals(that.locationAttribute))) {
            return false;
        }
        if (!(this.rootMosaicDirectory == null && that.rootMosaicDirectory == null || this.rootMosaicDirectory.equals(that.rootMosaicDirectory))) {
            return false;
        }
        return Utilities.deepEquals(this.indexingDirectories, that.indexingDirectories);
    }

    public int hashCode() {
        int seed = 37;
        seed = Utilities.hash((boolean)this.absolute, (int)seed);
        seed = Utilities.hash((boolean)this.recursive, (int)seed);
        seed = Utilities.hash((boolean)this.caching, (int)seed);
        seed = Utilities.hash((boolean)this.footprintManagement, (int)seed);
        seed = Utilities.hash((Object)this.locationAttribute, (int)seed);
        seed = Utilities.hash((Object)this.indexName, (int)seed);
        seed = Utilities.hash((Object)this.wildcard, (int)seed);
        seed = Utilities.hash((Object)this.rootMosaicDirectory, (int)seed);
        seed = Utilities.hash(this.indexingDirectories, (int)seed);
        return seed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CatalogBuilderConfiguration").append("\n");
        builder.append("wildcardString:\t\t\t").append(this.wildcard).append("\n");
        builder.append("indexName:\t\t\t").append(this.indexName).append("\n");
        builder.append("absolute:\t\t\t").append(this.absolute).append("\n");
        builder.append("caching:\t\t\t").append(this.caching).append("\n");
        builder.append("recursive:\t\t\t").append(this.recursive).append("\n");
        builder.append("footprintManagement:\t\t\t").append(this.footprintManagement).append("\n");
        builder.append("locationAttribute:\t\t\t").append(this.locationAttribute).append("\n");
        builder.append("rootMosaicDirectory:\t\t\t").append(this.rootMosaicDirectory).append("\n");
        builder.append("indexingDirectories:\t\t\t").append(Utilities.deepToString(this.indexingDirectories)).append("\n");
        return builder.toString();
    }

    public void check() throws IllegalStateException {
        if (this.indexingDirectories == null || this.indexingDirectories.size() <= 0) {
            throw new IllegalStateException("Indexing directories are empty");
        }
        ArrayList<String> directories = new ArrayList<String>();
        for (String dir : this.indexingDirectories) {
            directories.add(Utils.checkDirectory(dir));
        }
        this.indexingDirectories = directories;
        if (this.indexName == null || this.indexName.length() == 0) {
            throw new IllegalStateException("Index name cannot be empty");
        }
        if (this.rootMosaicDirectory == null || this.rootMosaicDirectory.length() == 0) {
            throw new IllegalStateException("RootMosaicDirectory name cannot be empty");
        }
        this.rootMosaicDirectory = Utils.checkDirectory(this.rootMosaicDirectory);
        if (this.wildcard == null || this.wildcard.length() == 0) {
            throw new IllegalStateException("WildcardString name cannot be empty");
        }
    }
}

