/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.catalog.AbstractGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.geometry.BoundingBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class STRTreeGranuleCatalog
extends AbstractGranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(STRTreeGranuleCatalog.class);
    private GranuleCatalog wrappedCatalogue;
    private SoftReference<STRtree> index = new SoftReference<Object>(null);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public STRTreeGranuleCatalog(Map<String, Serializable> params, DataStoreFactorySpi spi) {
        Utilities.ensureNonNull((String)"params", params);
        try {
            this.wrappedCatalogue = new GTDataStoreGranuleCatalog(params, false, spi);
        }
        catch (Throwable e) {
            block5: {
                try {
                    if (this.wrappedCatalogue != null) {
                        this.wrappedCatalogue.dispose();
                    }
                }
                catch (Throwable e2) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block5;
                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                }
            }
            throw new IllegalArgumentException(e);
        }
    }

    public STRTreeGranuleCatalog(GranuleCatalog catalogue) {
        Utilities.ensureNonNull((String)"catalogue", (Object)catalogue);
        this.wrappedCatalogue = catalogue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpatialIndex getIndex(Lock readLock) throws IOException {
        Lock writeLock = this.rwLock.writeLock();
        try {
            readLock.unlock();
            writeLock.lock();
            this.checkStore();
            STRtree tree = this.index.get();
            if (tree == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("No index exits and we create a new one.");
                }
                this.createIndex();
                tree = this.index.get();
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index does not need to be created...");
            }
            STRtree sTRtree = tree;
            Object var6_5 = null;
            readLock.lock();
            writeLock.unlock();
            return sTRtree;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            readLock.lock();
            writeLock.unlock();
            throw throwable;
        }
    }

    private void createIndex() {
        Iterator<GranuleDescriptor> it = null;
        Collection<GranuleDescriptor> features = null;
        try {
            features = this.wrappedCatalogue.getGranules();
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            if (!(it = features.iterator()).hasNext()) {
                throw new IllegalArgumentException("The provided SimpleFeatureCollection  or empty, it's impossible to create an index!");
            }
            STRtree tree = new STRtree();
            while (it.hasNext()) {
                GranuleDescriptor granule = it.next();
                ReferencedEnvelope env = ReferencedEnvelope.reference(granule.getGranuleBBOX());
                Polygon g = FeatureUtilities.getPolygon((Rectangle2D)new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight()), (int)0);
                tree.insert(g.getEnvelopeInternal(), (Object)granule);
            }
            tree.build();
            this.index = new SoftReference<STRtree>(tree);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GranuleDescriptor> getGranules(BoundingBox envelope) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            List list = this.getIndex(lock).query(ReferencedEnvelope.reference(envelope));
            Object var5_4 = null;
            lock.unlock();
            return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getGranules(BoundingBox envelope, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"envelope", (Object)envelope);
        Utilities.ensureNonNull((String)"visitor", (Object)visitor);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.getIndex(lock).query(ReferencedEnvelope.reference(envelope), new JTSIndexVisitorAdapter(visitor));
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            block9: {
                block8: {
                    l.lock();
                    if (this.index != null) {
                        try {
                            this.index.clear();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block8;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                }
                if (this.wrappedCatalogue != null) {
                    try {
                        this.wrappedCatalogue.dispose();
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block9;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
            Object var4_4 = null;
            this.wrappedCatalogue = null;
            this.index = null;
            l.unlock();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.wrappedCatalogue = null;
            this.index = null;
            l.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GranuleDescriptor> getGranules(Query q) throws IOException {
        List features;
        Filter filter;
        Lock lock;
        block4: {
            Utilities.ensureNonNull((String)"q", (Object)q);
            lock = this.rwLock.readLock();
            lock.lock();
            this.checkStore();
            filter = q.getFilter();
            ReferencedEnvelope requestedBBox = this.extractAndCombineBBox(filter);
            features = this.getIndex(lock).query(requestedBBox);
            if (!q.equals(Query.ALL)) break block4;
            List list = features;
            Object var11_8 = null;
            lock.unlock();
            return list;
        }
        try {
            ArrayList<GranuleDescriptor> retVal = new ArrayList<GranuleDescriptor>();
            for (GranuleDescriptor g : features) {
                SimpleFeature originator = g.getOriginator();
                if (originator == null || !filter.evaluate((Object)originator)) continue;
                retVal.add(g);
            }
            ArrayList<GranuleDescriptor> arrayList = retVal;
            Object var11_9 = null;
            lock.unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private ReferencedEnvelope extractAndCombineBBox(Filter filter) {
        GTDataStoreGranuleCatalog.BBOXFilterExtractor bboxExtractor = new GTDataStoreGranuleCatalog.BBOXFilterExtractor();
        filter.accept((FilterVisitor)bboxExtractor, null);
        ReferencedEnvelope requestedBBox = bboxExtractor.getBBox();
        if (requestedBBox == null) {
            return ReferencedEnvelope.reference(this.wrappedCatalogue.getBounds());
        }
        Envelope intersection = requestedBBox.intersection(ReferencedEnvelope.reference(this.wrappedCatalogue.getBounds()));
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(intersection, this.wrappedCatalogue.getBounds().getCoordinateReferenceSystem());
        return requestedBBox;
    }

    public List<GranuleDescriptor> getGranules() throws IOException {
        return this.getGranules(this.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getGranules(Query q, GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"q", (Object)q);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            Filter filter = q.getFilter();
            ReferencedEnvelope requestedBBox = this.extractAndCombineBBox(filter);
            this.getIndex(lock).query(requestedBBox, new JTSIndexVisitorAdapter(visitor, q));
            Object var7_6 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            BoundingBox boundingBox = this.wrappedCatalogue.getBounds();
            Object var4_3 = null;
            lock.unlock();
            return boundingBox;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.wrappedCatalogue == null) {
            throw new IllegalStateException("The underlying store has already been disposed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType getType() throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType simpleFeatureType = this.wrappedCatalogue.getType();
            Object var4_3 = null;
            lock.unlock();
            return simpleFeatureType;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            this.wrappedCatalogue.computeAggregateFunction(query, function);
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCapabilities getQueryCapabilities() {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.wrappedCatalogue.getQueryCapabilities();
            Object var4_3 = null;
            lock.unlock();
            return queryCapabilities;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private static class JTSIndexVisitorAdapter
    implements ItemVisitor {
        private GranuleCatalogVisitor adaptee;
        private Filter filter;

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee) {
            this(adaptee, (Query)null);
        }

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee, Query q) {
            this.adaptee = adaptee;
            this.filter = q == null ? Query.ALL.getFilter() : q.getFilter();
        }

        public JTSIndexVisitorAdapter(GranuleCatalogVisitor adaptee, Filter filter) {
            this.adaptee = adaptee;
            this.filter = filter == null ? Query.ALL.getFilter() : filter;
        }

        public void visitItem(Object o) {
            if (o instanceof GranuleDescriptor) {
                GranuleDescriptor g = (GranuleDescriptor)o;
                SimpleFeature originator = g.getOriginator();
                if (originator != null && this.filter.evaluate((Object)originator)) {
                    this.adaptee.visit(g, null);
                }
                return;
            }
            throw new IllegalArgumentException("Unable to visit provided item" + o);
        }
    }
}

