/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.gwc.GWC;
import org.geotools.util.logging.Logging;

public class GWCCatalogListener
implements CatalogListener {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWCCatalogListener");
    private final Catalog cat;
    private final GWC gwc;

    public GWCCatalogListener(Catalog cat, GWC gwc) {
        this.cat = cat;
        this.gwc = gwc;
        cat.addListener((CatalogListener)this);
        log.fine("GWCCatalogListener registered with catalog");
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            this.gwc.createLayer(layerInfo);
        } else if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgi = (LayerGroupInfo)obj;
            this.gwc.createLayer(lgi);
        }
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (obj instanceof StyleInfo) {
            StyleInfo si = (StyleInfo)obj;
            String styleName = si.getName();
            LinkedList<String> layerNameList = new LinkedList<String>();
            for (LayerInfo li : this.cat.getLayers()) {
                StyleInfo defaultStyle = li.getDefaultStyle();
                if (defaultStyle == null || !defaultStyle.getName().equals(styleName)) continue;
                String prefixedName = li.getResource().getPrefixedName();
                layerNameList.add(prefixedName);
                this.gwc.truncate(prefixedName);
            }
            for (LayerGroupInfo lgi : this.cat.getLayerGroups()) {
                boolean truncate = false;
                Iterator liter = lgi.getLayers().iterator();
                while (!truncate && liter.hasNext()) {
                    LayerInfo li = (LayerInfo)liter.next();
                    if (!layerNameList.contains(li.getResource().getPrefixedName())) continue;
                    truncate = true;
                }
                if (!truncate) {
                    Iterator siiter = lgi.getStyles().iterator();
                    while (!truncate && siiter.hasNext()) {
                        StyleInfo si2 = (StyleInfo)siiter.next();
                        if (si2 == null || !si2.getName().equals(si.getName())) continue;
                        truncate = true;
                    }
                }
                if (!truncate) continue;
                this.gwc.truncate(lgi.getName());
            }
        } else if (obj instanceof LayerInfo) {
            LayerInfo li = (LayerInfo)obj;
            this.gwc.createLayer(li);
        } else if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            this.gwc.createLayer(lgInfo);
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        String prefixedName = null;
        if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            prefixedName = lgInfo.getName();
        } else if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            prefixedName = layerInfo.getResource().getPrefixedName();
        }
        if (null != prefixedName) {
            this.gwc.removeLayer(prefixedName);
        }
    }

    public void reloaded() {
        this.gwc.reload();
    }
}

