/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.ows.Dispatcher;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSGeoServerHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogConfiguration
implements Configuration {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWCCatalogListener");
    private final Catalog cat;
    private final GridSetBroker gridSetBroker;
    private final Dispatcher gsDispatcher;
    private final Map<String, TileLayer> layers;
    private final int[] metaFactors = new int[]{4, 4};
    private final String wmsUrl;
    private final List<String> mimeFormats;

    public CatalogConfiguration(GridSetBroker gridSetBroker, Catalog cat, Dispatcher gsDispatcher) {
        this.wmsUrl = null;
        this.cat = cat;
        this.gridSetBroker = gridSetBroker;
        this.gsDispatcher = gsDispatcher;
        this.layers = new HashMap<String, TileLayer>();
        this.mimeFormats = new ArrayList<String>(5);
        this.mimeFormats.add("image/png");
        this.mimeFormats.add("image/gif");
        this.mimeFormats.add("image/png8");
        this.mimeFormats.add("image/jpeg");
        this.mimeFormats.add("application/vnd.google-earth.kml+xml");
    }

    public String getIdentifier() throws GeoWebCacheException {
        return "GeoServer Catalog Configuration";
    }

    public Catalog getCatalog() {
        return this.cat;
    }

    public ServiceInformation getServiceInformation() throws GeoWebCacheException {
        return null;
    }

    public boolean isRuntimeStatsEnabled() {
        return true;
    }

    public synchronized List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        if (reload) {
            this.layers.clear();
        }
        if (this.layers.isEmpty()) {
            for (LayerInfo li : this.cat.getLayers()) {
                this.createLayer(li);
            }
            for (LayerGroupInfo lgi : this.cat.getLayerGroups()) {
                this.createLayer(lgi);
            }
        }
        log.fine("Responding with " + this.layers.size() + " to getTileLayers() request from TileLayerDispatcher");
        return new ArrayList<TileLayer>(this.layers.values());
    }

    public TileLayer createLayer(LayerInfo li) {
        ResourceInfo resourceInfno = li.getResource();
        String layerName = resourceInfno.getPrefixedName();
        String[] wmsURL = this.getWMSUrl();
        String wmsStyles = null;
        String wmsLayers = resourceInfno.getPrefixedName();
        ReferencedEnvelope latLonBounds = resourceInfno.getLatLonBoundingBox();
        if (latLonBounds == null) {
            log.severe("LatLonBoundingBox of " + li.getName() + " is null, can't create a tile layer for it");
            return null;
        }
        Hashtable<String, GridSubset> subSets = this.getGrids(latLonBounds);
        List parameterFilters = null;
        String vendorParams = null;
        boolean queryable = true;
        WMSLayer retLayer = new WMSLayer(layerName, wmsURL, wmsStyles, wmsLayers, this.mimeFormats, subSets, parameterFilters, this.metaFactors, vendorParams, true);
        retLayer.setBackendTimeout(120);
        retLayer.setSourceHelper((WMSSourceHelper)new WMSGeoServerHelper(this.gsDispatcher));
        retLayer.initialize(this.gridSetBroker);
        this.layers.put(layerName, (TileLayer)retLayer);
        return retLayer;
    }

    public TileLayer createLayer(LayerGroupInfo lgi) {
        ReferencedEnvelope latLonBounds = null;
        try {
            latLonBounds = lgi.getBounds().transform(CRS.decode((String)"EPSG:4326"), true);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        if (latLonBounds == null) {
            log.severe("GWCCatalogListener had problems getting or reprojecting " + lgi.getBounds() + " to EPSG:4326");
            return null;
        }
        String layerName = lgi.getName();
        String[] wmsURL = this.getWMSUrl();
        String wmsStyles = null;
        String wmsLayers = lgi.getName();
        Hashtable<String, GridSubset> subSets = this.getGrids(latLonBounds);
        List parameterFilters = null;
        String vendorParams = null;
        boolean queryable = true;
        WMSLayer retLayer = new WMSLayer(layerName, wmsURL, wmsStyles, wmsLayers, this.mimeFormats, subSets, parameterFilters, this.metaFactors, vendorParams, true);
        retLayer.setBackendTimeout(120);
        retLayer.setSourceHelper((WMSSourceHelper)new WMSGeoServerHelper(this.gsDispatcher));
        retLayer.initialize(this.gridSetBroker);
        this.layers.put(layerName, (TileLayer)retLayer);
        return retLayer;
    }

    private String[] getWMSUrl() {
        String[] strs = new String[]{this.wmsUrl};
        return strs;
    }

    private Hashtable<String, GridSubset> getGrids(ReferencedEnvelope env) {
        double minX = env.getMinX();
        double minY = env.getMinY();
        double maxX = env.getMaxX();
        double maxY = env.getMaxY();
        BoundingBox bounds4326 = new BoundingBox(minX, minY, maxX, maxY);
        BoundingBox bounds900913 = new BoundingBox(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
        Hashtable<String, GridSubset> grids = new Hashtable<String, GridSubset>(2);
        GridSubset gridSubset4326 = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.WORLD_EPSG4326, (BoundingBox)bounds4326, (Integer)0, (Integer)25);
        grids.put(this.gridSetBroker.WORLD_EPSG4326.getName(), gridSubset4326);
        GridSubset gridSubset900913 = GridSubsetFactory.createGridSubSet((GridSet)this.gridSetBroker.WORLD_EPSG3857, (BoundingBox)bounds900913, (Integer)0, (Integer)25);
        grids.put(this.gridSetBroker.WORLD_EPSG3857.getName(), gridSubset900913);
        return grids;
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        y = Math.PI / 180 * y;
        double tmp = 0.7853981633974483 + y / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }

    public synchronized void removeLayer(String layerName) {
        this.layers.remove(layerName);
    }
}

