/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.util.SimpleInternationalString;
import org.geotools.xml.gml.ChoiceAttributeType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChoiceAttributeTypeImpl
extends AttributeTypeImpl
implements ChoiceAttributeType {
    private static final Class[] EMPTY = new Class[0];
    protected Class[] types;
    private boolean isNillable;
    private int maxOccurs;
    private int minOccurs;
    Object defaultValue;

    public ChoiceAttributeTypeImpl(Name name, Class<?>[] types, Class<?> defaultType, boolean nillable, int min, int max, Object defaultValue, List<Filter> filter) {
        super(name, defaultType, false, false, filter, null, ChoiceAttributeTypeImpl.toDescription(types));
        if (defaultValue == null && !this.isNillable) {
            defaultValue = DataUtilities.defaultValue(defaultType);
        }
        this.minOccurs = min;
        this.maxOccurs = max;
    }

    @Override
    public Class[] getChoices() {
        return EMPTY;
    }

    @Override
    public Object convert(Object obj) {
        return obj;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    public AttributeType getType() {
        return this;
    }

    public int getMaxOccurs() {
        return this.minOccurs;
    }

    public int getMinOccurs() {
        return this.maxOccurs;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    static InternationalString toDescription(Class[] bindings) {
        StringBuffer buf = new StringBuffer();
        buf.append("Choice betwee ");
        for (Class bind : bindings) {
            buf.append(bind.getName());
            buf.append(",");
        }
        return new SimpleInternationalString(buf.toString());
    }
}

