/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.web.demo.AffineTransformPanel;
import org.geoserver.wcs.web.demo.CoverageNamesModel;
import org.geoserver.wcs.web.demo.GetCoverageRequest;
import org.geoserver.wcs.web.demo.GridPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestResponse;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class WCSRequestBuilderPanel
extends Panel {
    static final Logger LOGGER = Logging.getLogger(WCSRequestBuilderPanel.class);
    GetCoverageRequest getCoverage;
    String description;
    ModalWindow responseWindow;
    private Component feedback;
    private WebMarkupContainer details;
    private EnvelopePanel envelope;
    private DropDownChoice<String> coverage;
    private DropDownChoice<String> formats;
    private CRSPanel targetCRS;
    private CheckBox manualGrid;
    private GridPanel sourceGridRange;
    private AffineTransformPanel g2w;
    private DropDownChoice<TargetLayout> targetLayoutChooser;
    private WebMarkupContainer targetlayoutContainer;
    private WebMarkupContainer sourceGridContainer;
    private GeoServerAjaxFormLink describeLink;

    public WCSRequestBuilderPanel(String id, GetCoverageRequest getCoverage) {
        super(id);
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new Model((Serializable)getCoverage));
        this.getCoverage = getCoverage;
        this.feedback = new FeedbackPanel("feedback");
        this.feedback.setOutputMarkupId(true);
        this.add(new Component[]{this.feedback});
        final DropDownChoice version = new DropDownChoice("version", (IModel)new PropertyModel((Object)getCoverage, "version"), Arrays.asList(GetCoverageRequest.Version.values()));
        this.add(new Component[]{version});
        version.add(new IBehavior[]{new AjaxFormSubmitBehavior("onchange"){

            protected void onError(AjaxRequestTarget target) {
                this.onSubmit(target);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                if (version.getModelObject() == GetCoverageRequest.Version.v1_0_0) {
                    WCSRequestBuilderPanel.this.sourceGridContainer.setVisible(true);
                    WCSRequestBuilderPanel.this.targetlayoutContainer.setVisible(false);
                    WCSRequestBuilderPanel.this.manualGrid.setModelObject((Object)false);
                    WCSRequestBuilderPanel.this.sourceGridRange.setVisible(false);
                } else {
                    WCSRequestBuilderPanel.this.targetlayoutContainer.setVisible(true);
                    WCSRequestBuilderPanel.this.sourceGridContainer.setVisible(false);
                    WCSRequestBuilderPanel.this.targetLayoutChooser.setModelObject((Object)TargetLayout.Automatic);
                    WCSRequestBuilderPanel.this.g2w.setModelObject(null);
                    WCSRequestBuilderPanel.this.g2w.setVisible(false);
                }
                target.addComponent((Component)WCSRequestBuilderPanel.this);
            }
        }});
        this.coverage = new DropDownChoice("coverage", (IModel)new PropertyModel((Object)getCoverage, "coverage"), (IModel)new CoverageNamesModel());
        this.add(new Component[]{this.coverage});
        this.coverage.add(new IBehavior[]{new AjaxFormSubmitBehavior("onchange"){

            protected void onError(AjaxRequestTarget target) {
                this.onSubmit(target);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                WCSRequestBuilderPanel.this.details.setVisible(true);
                String coverageName = (String)WCSRequestBuilderPanel.this.coverage.getModelObject();
                Catalog catalog = GeoServerApplication.get().getCatalog();
                CoverageInfo ci = catalog.getCoverageByName(coverageName);
                ReferencedEnvelope ri = ci.getNativeBoundingBox();
                GetCoverageRequest gc = WCSRequestBuilderPanel.this.getCoverage;
                gc.bounds = ri;
                gc.targetCRS = ri.getCoordinateReferenceSystem();
                gc.sourceGridRange = null;
                WCSRequestBuilderPanel.this.describeLink.setEnabled(true);
                target.addComponent((Component)WCSRequestBuilderPanel.this);
            }
        }});
        this.details = new WebMarkupContainer("details");
        this.details.setOutputMarkupId(true);
        this.details.setVisible(false);
        this.add(new Component[]{this.details});
        this.envelope = new EnvelopePanel("envelope", (IModel)new PropertyModel((Object)getCoverage, "bounds"));
        this.envelope.setCRSFieldVisible(true);
        this.envelope.setCrsRequired(true);
        this.details.add(new Component[]{this.envelope});
        this.buildGridPanel();
        this.formats = new DropDownChoice("format", (IModel)new PropertyModel((Object)getCoverage, "outputFormat"), GetCoverageRequest.FORMATS);
        this.details.add(new Component[]{this.formats});
        this.targetCRS = new CRSPanel("targetCRS", (IModel)new PropertyModel((Object)getCoverage, "targetCRS"));
        this.details.add(new Component[]{this.targetCRS});
        this.buildAffinePanel();
        this.responseWindow = new ModalWindow("responseWindow");
        this.add(new Component[]{this.responseWindow});
        this.responseWindow.setPageCreator(new ModalWindow.PageCreator(){

            public Page createPage() {
                DemoRequest request = new DemoRequest(null);
                HttpServletRequest http = ((WebRequest)WCSRequestBuilderPanel.this.getRequest()).getHttpServletRequest();
                String url = ResponseUtils.buildURL((String)ResponseUtils.baseURL((HttpServletRequest)http), (String)"ows", Collections.singletonMap("strict", "true"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                request.setRequestUrl(url);
                request.setRequestBody((String)WCSRequestBuilderPanel.this.responseWindow.getDefaultModelObject());
                return new DemoRequestResponse((IModel)new Model((Serializable)request));
            }
        });
        this.describeLink = new GeoServerAjaxFormLink("describeCoverage"){

            protected void onClick(AjaxRequestTarget target, Form form) {
                version.processInput();
                WCSRequestBuilderPanel.this.coverage.processInput();
                String coverageName = WCSRequestBuilderPanel.this.getCoverage.coverage;
                if (coverageName != null) {
                    WCSRequestBuilderPanel.this.responseWindow.setDefaultModel((IModel)new Model((Serializable)((Object)WCSRequestBuilderPanel.this.getDescribeXML(coverageName))));
                    WCSRequestBuilderPanel.this.responseWindow.show(target);
                }
            }
        };
        this.describeLink.setEnabled(false);
        this.describeLink.setOutputMarkupId(true);
        this.add(new Component[]{this.describeLink});
    }

    protected String getDescribeXML(String processId) {
        if (this.getCoverage.version == GetCoverageRequest.Version.v1_0_0) {
            return "<DescribeCoverage\n  version=\"1.0.0\"\n  service=\"WCS\"\n  xmlns=\"http://www.opengis.net/wcs\"\n  xmlns:nurc=\"http://www.nurc.nato.int\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/describeCoverage.xsd\">\n  \n    <Coverage>" + this.getCoverage.coverage + "</Coverage>\n" + "    \n" + "</DescribeCoverage>";
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>" + this.getCoverage.coverage + "</wcs:Identifier>\r\n" + "</wcs:DescribeCoverage>";
    }

    private void buildAffinePanel() {
        this.targetlayoutContainer = new WebMarkupContainer("targetLayoutContainer");
        this.details.add(new Component[]{this.targetlayoutContainer});
        this.targetlayoutContainer.setVisible(false);
        this.targetLayoutChooser = new DropDownChoice("targetLayout", (IModel)new Model((Serializable)((Object)TargetLayout.Automatic)), Arrays.asList(TargetLayout.values()), (IChoiceRenderer)new TargetLayoutRenderer());
        this.targetlayoutContainer.add(new Component[]{this.targetLayoutChooser});
        this.g2w = new AffineTransformPanel("targetGridToWorld", (IModel)new PropertyModel((Object)this.getCoverage, "targetGridToWorld"));
        this.targetlayoutContainer.add(new Component[]{this.g2w});
        this.g2w.setVisible(false);
        this.g2w.setOutputMarkupId(true);
        this.targetLayoutChooser.add(new IBehavior[]{new AjaxFormSubmitBehavior("onchange"){

            protected void onError(AjaxRequestTarget target) {
                this.onSubmit(target);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                if (WCSRequestBuilderPanel.this.targetLayoutChooser.getModelObject() == TargetLayout.Affine) {
                    AffineTransform at = WCSRequestBuilderPanel.this.guessGridToWorld(false);
                    WCSRequestBuilderPanel.this.g2w.setResolutionModeEnabled(false);
                    WCSRequestBuilderPanel.this.g2w.setModelObject(at);
                    WCSRequestBuilderPanel.this.g2w.setVisible(true);
                } else if (WCSRequestBuilderPanel.this.targetLayoutChooser.getModelObject() == TargetLayout.Resolution) {
                    AffineTransform at = WCSRequestBuilderPanel.this.guessGridToWorld(true);
                    WCSRequestBuilderPanel.this.g2w.setResolutionModeEnabled(true);
                    WCSRequestBuilderPanel.this.g2w.setModelObject(at);
                    WCSRequestBuilderPanel.this.g2w.setVisible(true);
                } else {
                    WCSRequestBuilderPanel.this.g2w.setModelObject(null);
                    WCSRequestBuilderPanel.this.g2w.setVisible(false);
                }
                target.addComponent((Component)WCSRequestBuilderPanel.this);
            }
        }});
    }

    private void buildGridPanel() {
        this.sourceGridContainer = new WebMarkupContainer("sourceGridContainer");
        this.details.add(new Component[]{this.sourceGridContainer});
        this.manualGrid = new CheckBox("manualGrid", (IModel)new Model((Serializable)Boolean.FALSE));
        this.sourceGridContainer.add(new Component[]{this.manualGrid});
        this.sourceGridRange = new GridPanel("sourceGrid", (IModel)new PropertyModel((Object)this.getCoverage, "sourceGridRange"));
        this.sourceGridContainer.add(new Component[]{this.sourceGridRange});
        this.sourceGridRange.setVisible(false);
        this.sourceGridRange.setOutputMarkupId(true);
        this.manualGrid.add(new IBehavior[]{new AjaxFormSubmitBehavior("onchange"){

            protected void onError(AjaxRequestTarget target) {
                this.onSubmit(target);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                if (WCSRequestBuilderPanel.this.manualGrid.getModelObject() == Boolean.TRUE) {
                    GridEnvelope2D grid = WCSRequestBuilderPanel.this.guessGridLimits();
                    WCSRequestBuilderPanel.this.sourceGridRange.setModelObject(grid);
                    WCSRequestBuilderPanel.this.sourceGridRange.setVisible(true);
                } else {
                    WCSRequestBuilderPanel.this.sourceGridRange.setModelObject(null);
                    WCSRequestBuilderPanel.this.sourceGridRange.setVisible(false);
                }
                target.addComponent((Component)WCSRequestBuilderPanel.this);
            }
        }});
    }

    protected String getDescribeXML(String coverageId, GetCoverageRequest.Version version) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DescribeProcess service=\"WPS\" version=\"1.0.0\" xmlns=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n    <ows:Identifier>" + coverageId + "</ows:Identifier>\n" + "</DescribeProcess>";
    }

    public Component getFeedbackPanel() {
        return this.feedback;
    }

    GetCoverageRequest getCoverageRequest() {
        if (this.getCoverage.version == GetCoverageRequest.Version.v1_0_0) {
            if (this.manualGrid.getModelObject() != Boolean.TRUE) {
                this.getCoverage.sourceGridRange = this.guessGridLimits();
            }
        } else if (this.targetLayoutChooser.getModelObject() == TargetLayout.Automatic) {
            this.getCoverage.targetGridToWorld = this.guessGridToWorld(true);
        }
        return this.getCoverage;
    }

    GridEnvelope2D guessGridLimits() {
        try {
            String coverageName = (String)this.coverage.getModelObject();
            Catalog catalog = GeoServerApplication.get().getCatalog();
            CoverageInfo ci = catalog.getCoverageByName(coverageName);
            ReferencedEnvelope boundsNative = this.getCoverage.bounds.transform(ci.getCRS(), true);
            MathTransform w2g = ci.getGrid().getGridToCRS().inverse();
            Envelope ge = JTS.transform((Envelope)boundsNative, (MathTransform)w2g);
            GridEnvelope2D grid = new GridEnvelope2D(new Rectangle(0, 0, (int)ge.getWidth(), (int)ge.getHeight()));
            return grid;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to guess native grid", e);
            this.error((Serializable)((Object)("Failed to guess native grid: " + e.getMessage())));
            return null;
        }
    }

    AffineTransform guessGridToWorld(boolean resolutionMode) {
        try {
            String coverageName = (String)this.coverage.getModelObject();
            Catalog catalog = GeoServerApplication.get().getCatalog();
            CoverageInfo ci = catalog.getCoverageByName(coverageName);
            ReferencedEnvelope nativeBounds = this.getCoverage.bounds.transform(ci.getCRS(), true);
            ReferencedEnvelope targetBounds = nativeBounds.transform(this.getCoverage.targetCRS, true);
            GridEnvelope2D gridLimits = this.guessGridLimits();
            GridGeometry2D gg = new GridGeometry2D((GridEnvelope)gridLimits, (org.opengis.geometry.Envelope)targetBounds);
            AffineTransform at = (AffineTransform)gg.getGridToCRS(PixelInCell.CELL_CORNER);
            if (resolutionMode) {
                return AffineTransform.getScaleInstance(at.getScaleX(), at.getScaleY());
            }
            return at;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to guess target affine transform", e);
            this.error((Serializable)((Object)("Failed to guess native grid: " + e.getMessage())));
            return null;
        }
    }

    class TargetLayoutRenderer
    implements IChoiceRenderer {
        TargetLayoutRenderer() {
        }

        public Object getDisplayValue(Object object) {
            String name = ((TargetLayout)((Object)object)).name();
            return new StringResourceModel("tl." + name, (Component)WCSRequestBuilderPanel.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((TargetLayout)((Object)object)).name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TargetLayout {
        Automatic,
        Resolution,
        Affine;

    }
}

