/*
 * Decompiled with CFR 0.152.
 */
package simple.util.lease;

import simple.util.PriorityQueue;

final class ReactiveQueue
extends PriorityQueue {
    public ReactiveQueue() {
        super(20);
    }

    public ReactiveQueue(int capacity) {
        super(capacity);
    }

    public ReactiveQueue(int capacity, long maxPriority) {
        super(capacity, maxPriority);
    }

    public void add(Object element, long priority) {
        int pos;
        if (this.count >= this.capacity) {
            this.expandCapacity();
        }
        if ((pos = this.search(element)) < 0) {
            pos = ++this.count;
        }
        this.value[pos] = priority;
        this.data[pos] = element;
        if (this.value[pos / 2] < priority) {
            this.bubbleUp(pos);
        } else {
            this.bubbleDown(pos);
        }
    }

    private int search(Object element) {
        int i = 1;
        while (i <= this.count) {
            if (element == this.data[i]) {
                return i;
            }
            if (element.equals(this.data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

