/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.InputStream;
import simple.http.InputMonitor;
import simple.http.MonitoredInputStream;

class ChunkedInputStream
extends MonitoredInputStream {
    private static final byte[] token = new byte[]{13, 10, 13, 10};
    private byte[] buf = new byte[1024];
    private int chunk;
    private boolean foot;

    public ChunkedInputStream(InputStream in, InputMonitor mon) {
        this(in, mon, false);
    }

    public ChunkedInputStream(InputStream in, InputMonitor mon, boolean foot) {
        super(in, mon);
        this.foot = foot;
    }

    protected int readByte() throws IOException {
        int octet = -1;
        while (octet < 0) {
            if (this.chunk < 0) break;
            if (this.chunk > 0) {
                octet = this.in.read();
                if (--this.chunk != 0) break;
                this.doControl();
                break;
            }
            this.nextChunk();
        }
        return octet;
    }

    protected int readBytes(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || off > buf.length || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        return this.parseRead(buf, off, len);
    }

    private int parseRead(byte[] buf, int off, int len) throws IOException {
        int count = 0;
        while (count < len) {
            if (this.chunk < 0) {
                return count > 0 ? count : -1;
            }
            if (this.chunk > 0) {
                int read = Math.min(len - count, this.chunk);
                int size = this.in.read(buf, off, read);
                if (size < 0) {
                    return count > 0 ? count : -1;
                }
                if (size == 0) {
                    return count;
                }
                if (size == this.chunk) {
                    this.doControl();
                }
                this.chunk -= size;
                off += size;
                count += size;
                continue;
            }
            this.nextChunk();
        }
        return len;
    }

    private void nextChunk() throws IOException {
        int size = this.doLength();
        if (size < 0 && this.foot) {
            this.doFooter();
        }
        if (size < 0 && !this.foot) {
            this.doControl();
        }
        this.chunk = size;
    }

    private void doFooter() throws IOException {
        int off = 0;
        do {
            int read = this.in.read();
            byte oct = (byte)read;
            if (read < 0) {
                throw new IOException("Bad footer");
            }
            if (oct == token[off++]) continue;
            off = 0;
        } while (off != token.length);
    }

    private int doLength() throws IOException {
        int off = 0;
        while (true) {
            int read = this.in.read();
            byte octet = (byte)read;
            if (read < 0 || off >= this.buf.length) {
                throw new IOException("Bad length");
            }
            if (read == 10) {
                return this.parseSize(off - 1);
            }
            this.buf[off++] = octet;
        }
    }

    private void doControl() throws IOException {
        if (this.in.read() != 13 || this.in.read() != 10) {
            throw new IOException("Bad control");
        }
    }

    private int parseSize(int count) throws IOException {
        int size = 0;
        int off = 0;
        while (off < count) {
            int octet = this.toDecimal(this.buf[off]);
            if (octet < 0 && off == 0) {
                throw new IOException("Bad length");
            }
            if (octet < 0) break;
            size <<= 4;
            size ^= octet;
            ++off;
        }
        return size == 0 ? -1 : size;
    }

    private int toDecimal(byte octet) {
        if (octet >= 65 && octet <= 90) {
            return octet - 65 + 10;
        }
        if (octet >= 48 && octet <= 57) {
            return octet - 48;
        }
        if (octet >= 97 && octet <= 102) {
            return octet - 97 + 10;
        }
        return -1;
    }

    protected long skipBytes(long amount) throws IOException {
        long space = this.buf.length;
        long count = amount;
        while (amount > 0L) {
            long min = Math.min(amount, space);
            int num = this.parseRead(this.buf, 0, (int)min);
            if (num < 0) break;
            amount -= (long)num;
        }
        return count - amount;
    }

    protected int readyBytes() throws IOException {
        int size = this.chunk < 0 ? 0 : this.chunk;
        return Math.min(size, this.in.available());
    }

    protected void doClose() throws IOException {
        this.skip(this.available());
        if (this.chunk >= 0) {
            this.mon.notifyError(this.in);
        }
    }
}

