/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.ve;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class VEConverter
extends Service {
    public static final String SERVICE_VE = "ve";
    private static Log log = LogFactory.getLog(VEConverter.class);
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;

    public VEConverter(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb) {
        super(SERVICE_VE);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        Map params = request.getParameterMap();
        String layerId = super.getLayersParameter(request);
        String encoding = request.getCharacterEncoding();
        String strQuadKey = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"quadkey");
        String strFormat = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"format");
        String strCached = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"cached");
        String strMetaTiled = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"metatiled");
        long[] gridLoc = VEConverter.convert(strQuadKey);
        MimeType mimeType = null;
        if (strFormat != null) {
            try {
                mimeType = MimeType.createFromFormat((String)strFormat);
            }
            catch (MimeException me) {
                throw new ServiceException("Unable to determined requested format, " + strFormat);
            }
        }
        ConveyorTile ret = new ConveyorTile(this.sb, layerId, this.gsb.WORLD_EPSG3857.getName(), gridLoc, mimeType, null, request, response);
        if (strCached != null && !Boolean.parseBoolean(strCached)) {
            ret.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            if (strMetaTiled != null && !Boolean.parseBoolean(strMetaTiled)) {
                ret.setHint("not_cached,not_metatiled");
            } else {
                ret.setHint("not_cached");
            }
        }
        return ret;
    }

    public void handleRequest(ConveyorTile tile) throws GeoWebCacheException {
        if (tile.getHint() != null) {
            if (!tile.getHint().equals("not_cached,not_metatiled") && !tile.getHint().equals("not_cached")) {
                throw new GeoWebCacheException("Hint " + tile.getHint() + " is not known.");
            }
            TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
            if (tl == null) {
                throw new GeoWebCacheException("Unknown layer " + tile.getLayerId());
            }
            if (!tl.isCacheBypassAllowed().booleanValue()) {
                throw new GeoWebCacheException("Layer " + tile.getLayerId() + " is not configured to allow bypassing the cache.");
            }
            tile.setTileLayer(tl);
            tl.getNoncachedTile(tile);
            Service.writeTileResponse((ConveyorTile)tile, (boolean)false);
        }
    }

    public static long[] convert(String strQuadKey) {
        char[] quadArray = strQuadKey.toCharArray();
        long zoomLevel = quadArray.length;
        long extent = (long)Math.pow(2.0, zoomLevel);
        long yPos = 0L;
        long xPos = 0L;
        int i = 0;
        while ((long)i < zoomLevel) {
            char curChar = quadArray[i];
            extent /= 2L;
            if (curChar == '0') {
                yPos += extent;
            } else if (curChar == '1') {
                xPos += extent;
                yPos += extent;
            } else if (curChar != '2') {
                if (curChar == '3') {
                    xPos += extent;
                } else {
                    log.error((Object)("Don't know how to interpret quadKey: " + strQuadKey));
                    return null;
                }
            }
            ++i;
        }
        long[] gridLoc = new long[]{xPos, yPos, zoomLevel};
        return gridLoc;
    }
}

