/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.ServiceInfo;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.data.property.PropertyFeatureSource;
import org.geotools.data.property.PropertyFeatureWriter;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDataStore
extends AbstractDataStore {
    protected File directory;
    protected String namespaceURI;

    public PropertyDataStore(File dir) {
        this(dir, null);
    }

    public PropertyDataStore(File dir, String namespaceURI) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (namespaceURI == null) {
            namespaceURI = dir.getName();
        }
        this.directory = dir;
        this.namespaceURI = namespaceURI;
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.directory);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.directory.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    @Override
    public String[] getTypeNames() {
        String[] list = this.directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].substring(0, list[i].lastIndexOf(46));
        }
        return list;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        String typeSpec = this.property(typeName, "_");
        try {
            return DataUtilities.createType(this.namespaceURI, typeName, typeSpec);
        }
        catch (SchemaException e) {
            e.printStackTrace();
            throw new DataSourceException(typeName + " schema not available", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String property(String typeName, String key) throws IOException {
        File file = new File(this.directory, typeName + ".properties");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(key + "=")) {
                    String string = line.substring(key.length() + 1);
                    return string;
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        return new PropertyFeatureReader(this.directory, typeName);
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName) throws IOException {
        return new PropertyFeatureWriter(this, typeName);
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        File file = new File(this.directory, typeName + ".properties");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("_=");
        writer.write(DataUtilities.spec((FeatureType)featureType));
        writer.close();
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        return new PropertyFeatureSource(this, typeName);
    }
}

