/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticContentStep
extends WizardStep {
    private static final long serialVersionUID = 1L;
    private final boolean allowHtml;
    private IModel<?> content;

    public StaticContentStep(boolean allowHtml) {
        this.allowHtml = allowHtml;
        this.add(new Component[]{new Label("content", "")});
    }

    public StaticContentStep(IModel<String> title, IModel<String> summary, IModel<?> content, boolean allowHtml) {
        super(title, summary);
        this.content = content;
        this.allowHtml = allowHtml;
        this.add(new Component[]{new Label("content", content).setEscapeModelStrings(!allowHtml)});
    }

    public StaticContentStep(IModel<String> title, IModel<String> summary, String content, boolean allowHtml) {
        this(title, summary, (IModel<?>)new Model((Serializable)((Object)content)), allowHtml);
    }

    public StaticContentStep(String title, String summary, IModel<?> content, boolean allowHtml) {
        this((IModel<String>)new Model((Serializable)((Object)title)), (IModel<String>)new Model((Serializable)((Object)summary)), content, allowHtml);
    }

    public StaticContentStep(String title, String summary, String content, boolean allowHtml) {
        this(title, summary, (IModel<?>)new Model((Serializable)((Object)content)), allowHtml);
    }

    public final boolean getAllowHtml() {
        return this.allowHtml;
    }

    public final String getContent() {
        return this.content != null ? (String)this.content.getObject() : null;
    }

    public final IModel<?> getContentModel() {
        return this.content;
    }

    public final <T> void setContentModel(IModel<T> content) {
        this.content = content;
        this.replace(new Label("content", content).setEscapeModelStrings(!this.allowHtml));
    }
}

