/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.DefaultAbstractTree;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractTreeColumn;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.extensions.markup.html.tree.table.MiddleColumnsView;
import org.apache.wicket.extensions.markup.html.tree.table.SideColumnsView;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TreeTable
extends DefaultAbstractTree {
    private static final ResourceReference CSS = new ResourceReference(DefaultAbstractTree.class, "res/tree-table.css");
    private static final long serialVersionUID = 1L;
    private IColumn[] columns;

    public static Component newTreeCell(MarkupContainer parent, String id, TreeNode node, int level, IRenderNodeCallback callback, TreeTable table) {
        return table.newTreePanel(parent, id, node, level, callback);
    }

    public TreeTable(String id, IColumn[] columns) {
        super(id);
        this.init(columns);
    }

    public TreeTable(String id, IModel model, IColumn[] columns) {
        super(id, (IModel<TreeModel>)model);
        this.init(columns);
    }

    public TreeTable(String id, TreeModel model, IColumn[] columns) {
        super(id, model);
        this.init(columns);
    }

    private boolean hasLeftColumn() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!((Object)((Object)this.columns[i].getLocation().getAlignment())).equals((Object)ColumnLocation.Alignment.LEFT)) continue;
            return true;
        }
        return false;
    }

    protected void addHeader() {
        SideColumnsView sideColumns = new SideColumnsView("sideColumns", null);
        this.add(new Component[]{sideColumns});
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                Component component = column.newHeader((MarkupContainer)sideColumns, "" + i);
                sideColumns.add(new Component[]{component});
                sideColumns.addColumn(column, component, null);
            }
        }
        MiddleColumnsView middleColumns = new MiddleColumnsView("middleColumns", null, this.hasLeftColumn());
        this.add(new Component[]{middleColumns});
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.MIDDLE) continue;
                Component component = column.newHeader((MarkupContainer)middleColumns, "" + i);
                middleColumns.add(new Component[]{component});
                middleColumns.addColumn(column, component, null);
            }
        }
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    protected Component newTreePanel(MarkupContainer parent, String id, TreeNode node, int level, IRenderNodeCallback renderNodeCallback) {
        return new TreeFragment(id, node, level, renderNodeCallback);
    }

    protected void onBeforeAttach() {
        if (this.get("sideColumns") == null) {
            if (this.columns != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    IColumn column = this.columns[i];
                    column.setTreeTable(this);
                }
            }
            this.addHeader();
        }
    }

    protected void populateTreeItem(WebMarkupContainer item, int level) {
        final TreeNode node = (TreeNode)item.getDefaultModelObject();
        SideColumnsView sideColumns = new SideColumnsView("sideColumns", node);
        item.add(new Component[]{sideColumns});
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                Component component;
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.LEFT && column.getLocation().getAlignment() != ColumnLocation.Alignment.RIGHT) continue;
                IRenderable renderable = column.newCell(node, level);
                if (renderable == null) {
                    component = column.newCell((MarkupContainer)sideColumns, "" + i, node, level);
                    sideColumns.add(new Component[]{component});
                } else {
                    component = null;
                }
                sideColumns.addColumn(column, component, renderable);
            }
        }
        MiddleColumnsView middleColumns = new MiddleColumnsView("middleColumns", node, this.hasLeftColumn());
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                Component component;
                IColumn column = this.columns[i];
                if (column.getLocation().getAlignment() != ColumnLocation.Alignment.MIDDLE) continue;
                IRenderable renderable = column.newCell(node, level);
                if (renderable == null) {
                    component = column.newCell((MarkupContainer)middleColumns, "" + i, node, level);
                    middleColumns.add(new Component[]{component});
                } else {
                    component = null;
                }
                middleColumns.addColumn(column, component, renderable);
            }
        }
        item.add(new Component[]{middleColumns});
        item.add(new IBehavior[]{new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                if (TreeTable.this.getTreeState().isNodeSelected((Object)node)) {
                    tag.put("class", (CharSequence)"row-selected");
                } else {
                    tag.put("class", (CharSequence)"row");
                }
            }
        }});
    }

    private void init(IColumn[] columns) {
        boolean found = false;
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                IColumn column = columns[i];
                if (!(column instanceof AbstractTreeColumn)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalArgumentException("At least one column in TreeTable must be derived from AbstractTreeColumn.");
        }
        this.columns = columns;
        this.add(new Component[]{new Label("attachJavascript", (IModel)new Model<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return "Wicket.TreeTable.attachUpdate(\"" + TreeTable.this.getMarkupId() + "\");";
            }
        }).setEscapeModelStrings(false)});
    }

    private class TreeFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public TreeFragment(String id, final TreeNode node, int level, final IRenderNodeCallback renderNodeCallback) {
            super(id, "fragment", (MarkupContainer)TreeTable.this);
            this.add(new Component[]{TreeTable.this.newIndentation((MarkupContainer)this, "indent", node, level)});
            this.add(new Component[]{TreeTable.this.newJunctionLink((MarkupContainer)this, "link", "image", node)});
            MarkupContainer nodeLink = TreeTable.this.newNodeLink((MarkupContainer)this, "nodeLink", node);
            this.add(new Component[]{nodeLink});
            nodeLink.add(new Component[]{TreeTable.this.newNodeIcon(nodeLink, "icon", node)});
            nodeLink.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){
                private static final long serialVersionUID = 1L;

                public String getObject() {
                    return renderNodeCallback.renderNode(node);
                }
            })});
        }
    }

    public static interface IRenderNodeCallback
    extends IClusterable {
        public String renderNode(TreeNode var1);
    }
}

