/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;

final class SideColumnsView
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final List<IColumn> columns = new ArrayList<IColumn>();
    private final List<Component> components = new ArrayList<Component>();
    private final TreeNode node;
    private final List<IRenderable> renderables = new ArrayList<IRenderable>();

    public SideColumnsView(String id, TreeNode node) {
        super(id);
        this.setRenderBodyOnly(true);
        this.node = node;
    }

    public void addColumn(IColumn column, Component component, IRenderable renderable) {
        if (column.isVisible()) {
            if (column.getLocation().getAlignment() == ColumnLocation.Alignment.LEFT) {
                this.columns.add(column);
                this.components.add(component);
                this.renderables.add(renderable);
            } else {
                this.columns.add(0, column);
                this.components.add(0, component);
                this.renderables.add(0, renderable);
            }
        }
    }

    protected void onRender(MarkupStream markupStream) {
        int markupStart = markupStream.getCurrentIndex();
        Response response = RequestCycle.get().getResponse();
        boolean firstLeft = true;
        boolean rendered = false;
        for (int i = 0; i < this.columns.size(); ++i) {
            IColumn column = this.columns.get(i);
            Component component = this.components.get(i);
            IRenderable renderable = this.renderables.get(i);
            response.write((CharSequence)("<span class=\"b_\" style=\"" + this.renderColumnStyle(column) + "\">"));
            if (column.getLocation().getAlignment() == ColumnLocation.Alignment.LEFT && firstLeft) {
                response.write((CharSequence)"<span class=\"d_\">");
                firstLeft = false;
            } else {
                response.write((CharSequence)"<span class=\"c_\">");
            }
            if (component != null) {
                markupStream.setCurrentIndex(markupStart);
                component.render(markupStream);
                rendered = true;
            } else if (renderable != null) {
                renderable.render(this.node, response);
            } else {
                throw new IllegalStateException("Either renderable or cell component must be created for this node");
            }
            response.write((CharSequence)"</span></span>\n");
        }
        if (!rendered) {
            markupStream.skipComponent();
        }
    }

    private String renderColumnFloat(IColumn column) {
        ColumnLocation location = column.getLocation();
        if (location.getAlignment() == ColumnLocation.Alignment.LEFT) {
            return "left";
        }
        if (location.getAlignment() == ColumnLocation.Alignment.RIGHT) {
            return "right";
        }
        throw new IllegalStateException("Wrong column allignment.");
    }

    private String renderColumnStyle(IColumn column) {
        return "width:" + this.renderColumnWidth(column) + ";float:" + this.renderColumnFloat(column);
    }

    private String renderColumnWidth(IColumn column) {
        ColumnLocation location = column.getLocation();
        return "" + location.getSize() + this.renderUnit(location.getUnit());
    }

    private String renderUnit(ColumnLocation.Unit unit) {
        if (unit == ColumnLocation.Unit.EM) {
            return "em";
        }
        if (unit == ColumnLocation.Unit.PX) {
            return "px";
        }
        if (unit == ColumnLocation.Unit.PERCENT) {
            return "%";
        }
        throw new IllegalStateException("Wrong column unit for column aligned left or right.");
    }
}

