/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionFactory;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFunctionFactory
implements FunctionFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private Map<String, FunctionDescriptor> functionCache;

    @Override
    public List<FunctionName> getFunctionNames() {
        ArrayList<FunctionName> list = new ArrayList<FunctionName>(this.functionCache().size());
        for (FunctionDescriptor fd : this.functionCache().values()) {
            list.add(fd.name);
        }
        return list;
    }

    @Override
    public Function function(String name, List<Expression> parameters, Literal fallback) {
        FunctionDescriptor fd = this.functionCache().get(this.functionName(name));
        if (fd == null) {
            return null;
        }
        try {
            return fd.newFunction(parameters, fallback);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Unable to create function " + name + "Function", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FunctionDescriptor> functionCache() {
        if (this.functionCache == null) {
            DefaultFunctionFactory defaultFunctionFactory = this;
            synchronized (defaultFunctionFactory) {
                if (this.functionCache == null) {
                    this.loadFunctions();
                }
            }
        }
        return this.functionCache;
    }

    private void loadFunctions() {
        this.functionCache = new HashMap<String, FunctionDescriptor>();
        Set functions = CommonFactoryFinder.getFunctionExpressions(null);
        for (FunctionExpression function : functions) {
            FunctionDescriptor fd = new FunctionDescriptor(this.filterFactory.functionName(function.getName(), function.getArgCount()), function.getClass());
            this.functionCache.put(this.functionName(function.getName()), fd);
        }
        functions = CommonFactoryFinder.getFunctions(null);
        for (FunctionExpression function : functions) {
            int argc = function instanceof FunctionExpression ? function.getArgCount() : function.getParameters().size();
            FunctionDescriptor fd = new FunctionDescriptor(this.filterFactory.functionName(function.getName(), argc), function.getClass());
            this.functionCache.put(this.functionName(function.getName()), fd);
        }
    }

    private String functionName(String name) {
        int index = -1;
        index = name.indexOf("Function");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase().trim();
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FunctionDescriptor {
        FunctionName name;
        Class clazz;

        FunctionDescriptor(FunctionName name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        Function newFunction(List<Expression> parameters, Literal fallback) throws Exception {
            if (FunctionExpression.class.isAssignableFrom(this.clazz)) {
                FunctionExpression function = (FunctionExpression)this.clazz.newInstance();
                if (parameters != null) {
                    function.setParameters(parameters);
                }
                if (fallback != null && function instanceof ClassificationFunction) {
                    ClassificationFunction classification = (ClassificationFunction)function;
                    classification.setFallbackValue(fallback);
                }
                return function;
            }
            if (FunctionImpl.class.isAssignableFrom(this.clazz)) {
                FunctionImpl function = (FunctionImpl)this.clazz.newInstance();
                if (parameters != null) {
                    function.setParameters(parameters);
                }
                if (fallback != null) {
                    function.setFallbackValue(fallback);
                }
                return function;
            }
            Constructor constructor = this.clazz.getConstructor(List.class, Literal.class);
            return (Function)constructor.newInstance(parameters, fallback);
        }
    }
}

