/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.visitor.CalcResult;

public class AbstractCalcResult
implements CalcResult {
    public boolean isCompatible(CalcResult targetResults) {
        return targetResults == CalcResult.NULL_RESULT;
    }

    public CalcResult merge(CalcResult resultsToAdd) {
        if (resultsToAdd == CalcResult.NULL_RESULT) {
            return this;
        }
        if (!this.isCompatible(resultsToAdd)) {
            throw new IllegalArgumentException("Parameter is not a compatible type");
        }
        throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
    }

    public Object getValue() {
        return null;
    }

    public int toInt() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return 0;
    }

    public double toDouble() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        return 0.0;
    }

    public long toLong() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return 0L;
    }

    public float toFloat() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.floatValue();
        }
        return 0.0f;
    }

    public Geometry toGeometry() {
        Object value = this.getValue();
        if (value instanceof Geometry) {
            return (Geometry)this.getValue();
        }
        return null;
    }

    public Envelope toEnvelope() {
        Object value = this.getValue();
        if (value instanceof Envelope) {
            return (Envelope)value;
        }
        return null;
    }

    public Point toPoint() {
        Geometry geometry = this.toGeometry();
        return geometry.getCentroid();
    }

    public Set toSet() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            return set;
        }
        if (value.getClass().isArray()) {
            HashSet<Object> set = new HashSet<Object>(Arrays.asList((Object[])value));
            return set;
        }
        if (value instanceof Collection) {
            HashSet set = new HashSet((Collection)value);
            return set;
        }
        return null;
    }

    public List toList() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof HashSet) {
            HashSet set = (HashSet)value;
            return Arrays.asList(set.toArray());
        }
        if (value instanceof Collection) {
            return new ArrayList((Collection)value);
        }
        return null;
    }

    public Object[] toArray() {
        List list = this.toList();
        if (list == null) {
            return null;
        }
        return list.toArray();
    }

    public String[] toStringArray() {
        List list = this.toList();
        if (list == null) {
            return null;
        }
        String[] strings = new String[list.size()];
        return list.toArray(strings);
    }

    public Map toMap() {
        return (Map)this.getValue();
    }

    public String toString() {
        return this.getValue().toString();
    }
}

