/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.tms;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.mime.MimeType;

public class TMSDocumentFactory {
    TileLayerDispatcher tld;
    GridSetBroker gsb;
    String baseUrl;

    protected TMSDocumentFactory(TileLayerDispatcher tld, GridSetBroker gsb, String baseUrl) {
        this.tld = tld;
        this.gsb = gsb;
        this.baseUrl = baseUrl;
    }

    protected String getTileMapServiceDoc() {
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        str.append("<TileMapService version=\"1.0.0\" services=\"" + this.baseUrl + "\">\n");
        str.append("  <Title>Tile Map Service</Title>\n");
        str.append("  <Abstract>A Tile Map Service served by GeoWebCache</Abstract>\n");
        str.append("  <TileMaps>\n");
        for (TileLayer layer : this.tld.getLayerList()) {
            if (!layer.isEnabled()) continue;
            this.tileMapsForLayer(str, layer);
        }
        str.append("  </TileMaps>\n");
        str.append("</TileMapService>\n");
        return str.toString();
    }

    private void tileMapsForLayer(StringBuilder str, TileLayer layer) {
        for (GridSubset gridSub : layer.getGridSubsets().values()) {
            for (MimeType mimeType : layer.getMimeTypes()) {
                str.append("    <TileMap\n");
                str.append("      title=\"").append(this.tileMapTitle(layer)).append("\"\n");
                str.append("      srs=\"").append(gridSub.getSRS().toString()).append("\"\n");
                str.append("      profile=\"");
                str.append(this.profileForGridSet(gridSub.getGridSet()));
                str.append("\"\n");
                str.append("      href=\"").append(this.tileMapUrl(layer, gridSub, mimeType)).append("\" />\n");
            }
        }
    }

    protected String getTileMapDoc(TileLayer layer, GridSubset gridSub, GridSetBroker gsb, MimeType mimeType) {
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        str.append("<TileMap version=\"1.0.0\" tilemapservice=\"" + this.baseUrl + "/service/tms/1.0.0\">\n");
        str.append("  <Title>").append(this.tileMapTitle(layer)).append("</Title>\n");
        str.append("  <Abstract>").append(this.tileMapDescription(layer)).append("</Abstract>\n");
        str.append("  <SRS>").append(gridSub.getSRS().toString()).append("</SRS>\n");
        double[] coords = gridSub.getCoverageBestFitBounds().getCoords();
        str.append("  <BoundingBox minx=\"").append(coords[0]);
        str.append("\" miny=\"").append(coords[1]);
        str.append("\" maxx=\"").append(coords[2]);
        str.append("\" maxy=\"").append(coords[3]).append("\" />\n");
        str.append("  <Origin x=\"").append(coords[0]).append("\" y=\"").append(coords[1]).append("\" />\n");
        str.append("  <TileFormat width=\"").append(gridSub.getTileWidth());
        str.append("\" height=\"").append(gridSub.getTileHeight());
        str.append("\" mime-type=\"" + mimeType.getMimeType() + "\" extension=\"" + mimeType.getFileExtension() + "\" />\n");
        str.append("  <TileSets profile=\"");
        str.append(this.profileForGridSet(gridSub.getGridSet()));
        str.append("\">\n");
        double[] resolutions = gridSub.getResolutions();
        int resIdx = 0;
        for (int zoom = gridSub.getZoomStart(); zoom <= gridSub.getZoomStop(); ++zoom) {
            str.append("    <TileSet href=\"");
            str.append(this.tileMapUrl(layer, gridSub, mimeType, zoom));
            str.append("\" units-per-pixel=\"").append(resolutions[resIdx]);
            str.append("\" order=\"").append(resIdx).append("\"/>\n");
            ++resIdx;
        }
        str.append("  </TileSets>\n");
        str.append("</TileMap>\n");
        return str.toString();
    }

    private String profileForGridSet(GridSet gridSet) {
        if (gridSet == this.gsb.WORLD_EPSG4326) {
            return "global-geodetic";
        }
        if (gridSet == this.gsb.WORLD_EPSG3857) {
            return "global-mercator";
        }
        return "local";
    }

    private String tileMapUrl(TileLayer tl, GridSubset gridSub, MimeType mimeType) {
        return this.baseUrl + "/service/tms/1.0.0/" + this.tileMapName(tl, gridSub, mimeType);
    }

    private String tileMapUrl(TileLayer tl, GridSubset gridSub, MimeType mimeType, int z) {
        return this.tileMapUrl(tl, gridSub, mimeType) + "/" + z;
    }

    private String tileMapName(TileLayer tl, GridSubset gridSub, MimeType mimeType) {
        try {
            String name = URLEncoder.encode(tl.getName(), "UTF-8");
            String gridSubset = URLEncoder.encode(gridSub.getName(), "UTF-8");
            return name + "@" + gridSubset + "@" + mimeType.getFileExtension();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String tileMapTitle(TileLayer tl) {
        LayerMetaInformation metaInfo = tl.getMetaInformation();
        if (metaInfo != null && metaInfo.getTitle() != null) {
            return metaInfo.getTitle();
        }
        return tl.getName();
    }

    private String tileMapDescription(TileLayer tl) {
        LayerMetaInformation metaInfo = tl.getMetaInformation();
        if (metaInfo != null && metaInfo.getDescription() != null) {
            return metaInfo.getDescription();
        }
        return "";
    }
}

