/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.diskquota.storage.PagePyramid;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilePageCalculator {
    private TileLayerDispatcher tld;
    private Map<TileSet, PagePyramid> pagePyramids = new WeakHashMap<TileSet, PagePyramid>();

    public TilePageCalculator(TileLayerDispatcher tld) {
        this.tld = tld;
    }

    public TilePage pageForTile(TileSet tileSet, long[] tileIndex) {
        int[] pageIndexForTile = new int[3];
        this.pageIndexForTile(tileSet, tileIndex, null);
        String tileSetId = tileSet.getId();
        int pageX = pageIndexForTile[0];
        int pageY = pageIndexForTile[1];
        byte zoomLevel = (byte)pageIndexForTile[2];
        return new TilePage(tileSetId, pageX, pageY, zoomLevel);
    }

    public int[] pageIndexForTile(TileSet tileSet, long[] tileIndex, int[] pageIndexTarget) {
        Assert.notNull((Object)tileSet);
        Assert.notNull((Object)tileIndex);
        Assert.isTrue((pageIndexTarget != null && pageIndexTarget.length > 2 ? 1 : 0) != 0);
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        pagePyramid.pageIndexForTile(tileIndex[0], tileIndex[1], (int)tileIndex[2], pageIndexTarget);
        return pageIndexTarget;
    }

    private PagePyramid getPagePyramid(TileSet tileSet) {
        PagePyramid pagePyramid = this.pagePyramids.get(tileSet);
        if (pagePyramid == null) {
            pagePyramid = this.newPagePyramid(tileSet);
            this.pagePyramids.put(tileSet, pagePyramid);
        }
        return pagePyramid;
    }

    public BigInteger getTilesPerPage(TileSet tileSet, int zoomLevel) {
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        PagePyramid.PageLevelInfo pageInfo = pagePyramid.getPageInfo(zoomLevel);
        BigInteger tilesPerPage = pageInfo.tilesPerPage;
        return tilesPerPage;
    }

    public long[][] toGridCoverage(TileSet tileSet, TilePage page) {
        PagePyramid pagePyramid = this.getPagePyramid(tileSet);
        int pageX = page.getPageX();
        int pageY = page.getPageY();
        byte level = page.getZoomLevel();
        long[][] gridCoverage = pagePyramid.toGridCoverage(pageX, pageY, level);
        return gridCoverage;
    }

    public Set<String> getLayerNames() {
        return this.tld.getLayerNames();
    }

    public Set<TileSet> getTileSetsFor(String layerName) {
        TileLayer tileLayer;
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e);
        }
        Collection<GridSubset> gridSubSets = tileLayer.getGridSubsets().values();
        List mimeTypes = tileLayer.getMimeTypes();
        return this.getTileSetsFor(layerName, gridSubSets, mimeTypes);
    }

    public Set<TileSet> getTileSetsFor(String layerName, Collection<GridSubset> gridSubSets, List<MimeType> mimeTypes) {
        HashSet<TileSet> layerTileSets = new HashSet<TileSet>();
        Long parametersId = null;
        for (GridSubset gridSubset : gridSubSets) {
            String gridsetId = gridSubset.getName();
            for (MimeType mime : mimeTypes) {
                String blobFormat = mime.getFormat();
                TileSet tileSet = new TileSet(layerName, gridsetId, blobFormat, parametersId);
                layerTileSets.add(tileSet);
            }
        }
        return layerTileSets;
    }

    public Iterator<TilePage> computeAllPagesFor(TileSet tileSet) {
        PagePyramid pagePyramid = this.newPagePyramid(tileSet);
        return this.computeAllPagesFor(tileSet, pagePyramid);
    }

    Iterator<TilePage> computeAllPagesFor(TileSet tileSet, PagePyramid pagePyramid) {
        return new LazyTilePageIterator(tileSet, pagePyramid);
    }

    private PagePyramid newPagePyramid(TileSet tileSet) {
        TileLayer tileLayer;
        String layerName = tileSet.getLayerName();
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e);
        }
        GridSubset gridSubset = tileLayer.getGridSubset(tileSet.getGridsetId());
        return this.newPagePyramid(gridSubset);
    }

    PagePyramid newPagePyramid(GridSubset gridSubset) {
        int zoomStart = gridSubset.getZoomStart();
        int zoomStop = gridSubset.getZoomStop();
        long[][] coverages = gridSubset.getCoverages();
        PagePyramid pagePyramid = new PagePyramid(coverages, zoomStart, zoomStop);
        return pagePyramid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyTilePageIterator
    implements Iterator<TilePage> {
        private final TileSet tileSet;
        private final PagePyramid pagePyramid;
        private TilePage next;
        private byte currZoomLevel;
        private PagePyramid.PageLevelInfo currPageInfo;
        private int currX;
        private int currY;

        public LazyTilePageIterator(TileSet tileSet, PagePyramid pagePyramid) {
            this.tileSet = tileSet;
            this.pagePyramid = pagePyramid;
            this.currZoomLevel = (byte)pagePyramid.getZoomStart();
            this.currPageInfo = pagePyramid.getPageInfo(this.currZoomLevel);
            this.currX = 0;
            this.currY = 0;
            this.next = new TilePage(tileSet.getId(), this.currX, this.currY, this.currZoomLevel);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public TilePage next() {
            TilePage current = this.next;
            ++this.currX;
            int pagesX = this.currPageInfo.pagesX;
            if (this.currX == pagesX) {
                this.currX = 0;
                ++this.currY;
                int pagesY = this.currPageInfo.pagesY;
                if (this.currY == pagesY) {
                    this.currY = 0;
                    this.currZoomLevel = (byte)(this.currZoomLevel + 1);
                    int zoomStop = this.pagePyramid.getZoomStop();
                    if (this.currZoomLevel > zoomStop) {
                        this.next = null;
                        return current;
                    }
                    this.currPageInfo = this.pagePyramid.getPageInfo(this.currZoomLevel);
                }
            }
            this.next = new TilePage(this.tileSet.getId(), this.currX, this.currY, this.currZoomLevel);
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

