/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.storage.EntityStoreBuilder;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.PageStoreConfig;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.QuotaStore;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BDBQuotaStore
implements QuotaStore,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(BDBQuotaStore.class);
    private static final String GLOBAL_QUOTA_NAME = "___GLOBAL_QUOTA___";
    private EntityStore entityStore;
    private final String cacheRootDir;
    private final TilePageCalculator tilePageCalculator;
    private static ExecutorService transactionRunner;
    private PrimaryIndex<String, TileSet> tileSetById;
    private PrimaryIndex<Long, TilePage> pageById;
    private PrimaryIndex<Long, PageStats> pageStatsById;
    private PrimaryIndex<Integer, Quota> usedQuotaById;
    private SecondaryIndex<String, String, TileSet> tileSetsByLayer;
    private SecondaryIndex<String, Long, TilePage> pageByKey;
    private SecondaryIndex<Long, Long, PageStats> pageStatsByPageId;
    private SecondaryIndex<Float, Long, PageStats> pageStatsByLRU;
    private SecondaryIndex<Float, Long, PageStats> pageStatsByLFU;
    private SecondaryIndex<String, Integer, Quota> usedQuotaByTileSetId;
    private volatile boolean open;
    private boolean diskQuotaEnabled;

    public BDBQuotaStore(DefaultStorageFinder cacheDirFinder, TilePageCalculator tilePageCalculator) throws StorageException {
        Assert.notNull((Object)cacheDirFinder, (String)"cacheDirFinder can't be null");
        Assert.notNull((Object)tilePageCalculator, (String)"tilePageCalculator can't be null");
        this.tilePageCalculator = tilePageCalculator;
        this.cacheRootDir = cacheDirFinder.getDefaultPath();
        boolean disabled = Boolean.valueOf(cacheDirFinder.findEnvVar("GWC_DISKQUOTA_DISABLED"));
        if (disabled) {
            log.warn((Object)" -- Found environment variable GWC_DISKQUOTA_DISABLED set to true. DiskQuotaMonitor is disabled.");
        }
        this.diskQuotaEnabled = !disabled;
    }

    public void afterPropertiesSet() throws Exception {
        this.startUp();
    }

    public void startUp() throws InterruptedException {
        if (!this.diskQuotaEnabled) {
            log.info((Object)(this.getClass().getName() + " won't start, got env variable " + "GWC_DISKQUOTA_DISABLED" + "=true"));
            return;
        }
        this.open = true;
        File storeDirectory = new File(this.cacheRootDir, "diskquota_page_store");
        storeDirectory.mkdirs();
        CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC DiskQuota Store Writer-");
        transactionRunner = Executors.newFixedThreadPool(1, (ThreadFactory)tf);
        try {
            this.configure(storeDirectory);
            this.deleteStaleLayersAndCreateMissingTileSets();
            log.info((Object)("Berkeley DB JE Disk Quota page store configured at " + storeDirectory.getAbsolutePath()));
        }
        catch (RuntimeException e) {
            transactionRunner.shutdownNow();
            throw e;
        }
        log.info((Object)("Quota Store initialized. Global quota: " + this.getGloballyUsedQuota().toNiceString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (!this.diskQuotaEnabled) {
            return;
        }
        this.open = false;
        log.info((Object)"Requesting to close quota store...");
        transactionRunner.shutdown();
        try {
            transactionRunner.awaitTermination(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            log.error((Object)"Time out shutting down quota store write thread, trying to close the entity store as is.", (Throwable)ie);
        }
        finally {
            Environment environment = this.entityStore.getEnvironment();
            this.entityStore.close();
            environment.close();
        }
        log.info((Object)"Quota store closed.");
    }

    private void configure(File storeDirectory) throws InterruptedException {
        EntityStore entityStore;
        PageStoreConfig config = new PageStoreConfig();
        EntityStoreBuilder builder = new EntityStoreBuilder(config);
        this.entityStore = entityStore = builder.buildEntityStore(storeDirectory, null);
        this.tileSetById = entityStore.getPrimaryIndex(String.class, TileSet.class);
        this.pageById = entityStore.getPrimaryIndex(Long.class, TilePage.class);
        this.pageStatsById = entityStore.getPrimaryIndex(Long.class, PageStats.class);
        this.usedQuotaById = entityStore.getPrimaryIndex(Integer.class, Quota.class);
        this.pageByKey = entityStore.getSecondaryIndex(this.pageById, String.class, "page_key");
        this.tileSetsByLayer = entityStore.getSecondaryIndex(this.tileSetById, String.class, "layer");
        this.pageStatsByLRU = entityStore.getSecondaryIndex(this.pageStatsById, Float.class, "LRU");
        this.pageStatsByLFU = entityStore.getSecondaryIndex(this.pageStatsById, Float.class, "LFU");
        this.usedQuotaByTileSetId = entityStore.getSecondaryIndex(this.usedQuotaById, String.class, "tileset_id");
        this.pageStatsByPageId = entityStore.getSecondaryIndex(this.pageStatsById, Long.class, "page_stats_by_page_id");
    }

    private TileSet getOrCreateTileSet(Transaction transaction, TileSet tset) {
        String id = tset.getId();
        TileSet stored = (TileSet)this.tileSetById.get(transaction, (Object)id, LockMode.DEFAULT);
        if (null == stored) {
            log.debug((Object)("Creating TileSet for quota tracking: " + tset));
            this.tileSetById.putNoReturn(transaction, (Object)tset);
            stored = tset;
            Quota tileSetUsedQuota = new Quota();
            tileSetUsedQuota.setTileSetId(tset.getId());
            this.usedQuotaById.putNoReturn(transaction, (Object)tileSetUsedQuota);
        }
        return stored;
    }

    private <E> Future<E> issue(Callable<E> command) {
        if (!this.open) {
            throw new IllegalStateException("QuotaStore is closed.");
        }
        Future<E> future = transactionRunner.submit(command);
        return future;
    }

    private <E> E issueSync(Callable<E> command) throws InterruptedException {
        Future<E> result = this.issue(command);
        try {
            return result.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            log.debug((Object)("Caught InterruptedException while waiting for command " + command.getClass().getSimpleName()));
            throw e;
        }
        catch (ExecutionException e) {
            log.warn((Object)e);
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private void deleteStaleLayersAndCreateMissingTileSets() throws InterruptedException {
        this.issueSync(new StartUpInitializer());
    }

    public Quota getGloballyUsedQuota() throws InterruptedException {
        return this.getUsedQuotaByTileSetId(GLOBAL_QUOTA_NAME);
    }

    public Quota getUsedQuotaByTileSetId(String tileSetId) throws InterruptedException {
        Quota usedQuota = this.issueSync(new UsedQuotaByTileSetId(tileSetId));
        return usedQuota;
    }

    public void deleteLayer(String layerName) {
        this.issue(new DeleteLayer(layerName));
    }

    public Quota getUsedQuotaByLayerName(String layerName) throws InterruptedException {
        return this.issueSync(new UsedQuotaByLayerName(layerName));
    }

    public long[][] getTilesForPage(TilePage page) throws InterruptedException {
        TileSet tileSet = this.getTileSetById(page.getTileSetId());
        long[][] gridCoverage = this.tilePageCalculator.toGridCoverage(tileSet, page);
        return gridCoverage;
    }

    public Set<TileSet> getTileSets() {
        HashMap map = new HashMap(this.tileSetById.map());
        map.remove(GLOBAL_QUOTA_NAME);
        HashSet<TileSet> hashSet = new HashSet<TileSet>(map.values());
        return hashSet;
    }

    public TileSet getTileSetById(final String tileSetId) throws InterruptedException {
        return this.issueSync(new Callable<TileSet>(){

            @Override
            public TileSet call() throws Exception {
                TileSet tileSet = (TileSet)BDBQuotaStore.this.tileSetById.get((Object)tileSetId);
                if (tileSet == null) {
                    throw new IllegalArgumentException("TileSet does not exist: " + tileSetId);
                }
                return tileSet;
            }
        });
    }

    public TilePageCalculator getTilePageCalculator() {
        return this.tilePageCalculator;
    }

    public void addToQuotaAndTileCounts(TileSet tileSet, Quota quotaDiff, Collection<PageStatsPayload> tileCountDiffs) throws InterruptedException {
        this.issueSync(new AddToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs));
    }

    public Future<List<PageStats>> addHitsAndSetAccesTime(Collection<PageStatsPayload> statsUpdates) {
        Assert.notNull(statsUpdates);
        return this.issue(new AddHitsAndSetAccesTime(statsUpdates));
    }

    public TilePage getLeastFrequentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        SecondaryIndex<Float, Long, PageStats> expirationPolicyIndex = this.pageStatsByLFU;
        TilePage nextToExpire = this.issueSync(new FindPageToExpireByLayer(expirationPolicyIndex, layerNames));
        return nextToExpire;
    }

    public TilePage getLeastRecentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        SecondaryIndex<Float, Long, PageStats> expirationPolicyIndex = this.pageStatsByLRU;
        TilePage nextToExpire = this.issueSync(new FindPageToExpireByLayer(expirationPolicyIndex, layerNames));
        return nextToExpire;
    }

    public PageStats setTruncated(TilePage tilePage) throws InterruptedException {
        return this.issueSync(new TruncatePage(tilePage));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TruncatePage
    implements Callable<PageStats> {
        private final TilePage tilePage;

        public TruncatePage(TilePage tilePage) {
            this.tilePage = tilePage;
        }

        @Override
        public PageStats call() throws Exception {
            Transaction tx = BDBQuotaStore.this.entityStore.getEnvironment().beginTransaction(null, null);
            try {
                PageStats pageStats = (PageStats)BDBQuotaStore.this.pageStatsByPageId.get(tx, (Object)this.tilePage.getId(), null);
                if (pageStats != null) {
                    pageStats.setFillFactor(0.0f);
                    BDBQuotaStore.this.pageStatsById.putNoReturn(tx, (Object)pageStats);
                }
                tx.commit();
                return pageStats;
            }
            catch (Exception e) {
                tx.abort();
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindPageToExpireByLayer
    implements Callable<TilePage> {
        private final SecondaryIndex<Float, Long, PageStats> expirationPolicyIndex;
        private final Set<String> layerNames;

        public FindPageToExpireByLayer(SecondaryIndex<Float, Long, PageStats> expirationPolicyIndex, Set<String> layerNames) {
            this.expirationPolicyIndex = expirationPolicyIndex;
            this.layerNames = layerNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TilePage call() throws Exception {
            HashSet<String> tileSetIds = new HashSet<String>();
            for (String layerName : this.layerNames) {
                EntityCursor keys = BDBQuotaStore.this.tileSetsByLayer.entities((Object)layerName, true, (Object)layerName, true);
                try {
                    TileSet tileSet;
                    while ((tileSet = (TileSet)keys.next()) != null) {
                        tileSetIds.add(tileSet.getId());
                    }
                }
                finally {
                    keys.close();
                }
            }
            TilePage nextToExpire = null;
            EntityCursor pageStatsCursor = this.expirationPolicyIndex.entities();
            try {
                PageStats pageStats;
                while ((pageStats = (PageStats)pageStatsCursor.next()) != null) {
                    if (!(pageStats.getFillFactor() > 0.0f)) continue;
                    long pageId = pageStats.getPageId();
                    TilePage tilePage = (TilePage)BDBQuotaStore.this.pageById.get((Object)pageId);
                    String tileSetId = tilePage.getTileSetId();
                    if (!tileSetIds.contains(tileSetId)) continue;
                    nextToExpire = tilePage;
                    break;
                }
            }
            finally {
                pageStatsCursor.close();
            }
            return nextToExpire;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddHitsAndSetAccesTime
    implements Callable<List<PageStats>> {
        private final Collection<PageStatsPayload> statsUpdates;

        public AddHitsAndSetAccesTime(Collection<PageStatsPayload> statsUpdates) {
            this.statsUpdates = statsUpdates;
        }

        @Override
        public List<PageStats> call() throws Exception {
            ArrayList<PageStats> allStats = new ArrayList<PageStats>(this.statsUpdates.size());
            PageStats pageStats = null;
            Transaction tx = BDBQuotaStore.this.entityStore.getEnvironment().beginTransaction(null, null);
            try {
                for (PageStatsPayload payload : this.statsUpdates) {
                    TilePage page = payload.getPage();
                    TileSet storedTileset = (TileSet)BDBQuotaStore.this.tileSetById.get(tx, (Object)page.getTileSetId(), LockMode.DEFAULT);
                    if (null == storedTileset) {
                        log.info((Object)("Can't add usage stats. TileSet does not exist. Was it deleted? " + page.getTileSetId()));
                        continue;
                    }
                    TilePage storedPage = (TilePage)BDBQuotaStore.this.pageByKey.get(tx, (Object)page.getKey(), null);
                    if (storedPage == null) {
                        BDBQuotaStore.this.pageById.put(tx, (Object)page);
                        storedPage = page;
                        pageStats = new PageStats(storedPage.getId());
                    } else {
                        pageStats = (PageStats)BDBQuotaStore.this.pageStatsByPageId.get(tx, (Object)storedPage.getId(), null);
                    }
                    int addedHits = payload.getNumHits();
                    int lastAccessTimeMinutes = (int)(payload.getLastAccessTime() / 1000L / 60L);
                    int creationTimeMinutes = storedPage.getCreationTimeMinutes();
                    pageStats.addHitsAndAccessTime(addedHits, lastAccessTimeMinutes, creationTimeMinutes);
                    BDBQuotaStore.this.pageStatsById.putNoReturn(tx, (Object)pageStats);
                    allStats.add(pageStats);
                }
                tx.commit();
                return allStats;
            }
            catch (RuntimeException e) {
                tx.abort();
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddToQuotaAndTileCounts
    implements Callable<Void> {
        private final TileSet tileSet;
        private final Collection<PageStatsPayload> tileCountDiffs;
        private final Quota quotaDiff;

        public AddToQuotaAndTileCounts(TileSet tileSet, Quota quotaDiff, Collection<PageStatsPayload> tileCountDiffs) {
            this.tileSet = tileSet;
            this.quotaDiff = quotaDiff;
            this.tileCountDiffs = tileCountDiffs;
        }

        @Override
        public Void call() throws Exception {
            Transaction tx = BDBQuotaStore.this.entityStore.getEnvironment().beginTransaction(null, null);
            try {
                TileSet storedTileset = BDBQuotaStore.this.getOrCreateTileSet(tx, this.tileSet);
                this.addToUsedQuota(tx, storedTileset, this.quotaDiff);
                if (this.tileCountDiffs.size() > 0) {
                    for (PageStatsPayload payload : this.tileCountDiffs) {
                        PageStats pageStats;
                        TilePage page = payload.getPage();
                        String pageKey = page.getKey();
                        TilePage storedPage = (TilePage)BDBQuotaStore.this.pageByKey.get(tx, (Object)pageKey, LockMode.DEFAULT);
                        if (null == storedPage) {
                            BDBQuotaStore.this.pageById.put(tx, (Object)page);
                            storedPage = page;
                            pageStats = new PageStats(storedPage.getId());
                        } else {
                            pageStats = (PageStats)BDBQuotaStore.this.pageStatsByPageId.get(tx, (Object)storedPage.getId(), null);
                        }
                        byte level = page.getZoomLevel();
                        BigInteger tilesPerPage = BDBQuotaStore.this.tilePageCalculator.getTilesPerPage(this.tileSet, level);
                        int tilesAdded = payload.getNumTiles();
                        pageStats.addTiles(tilesAdded, tilesPerPage);
                        BDBQuotaStore.this.pageStatsById.putNoReturn(tx, (Object)pageStats);
                    }
                }
                tx.commit();
                return null;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                tx.abort();
                throw e;
            }
        }

        private void addToUsedQuota(Transaction tx, TileSet tileSet, Quota quotaDiff) {
            Quota usedQuota = (Quota)BDBQuotaStore.this.usedQuotaByTileSetId.get(tx, (Object)tileSet.getId(), LockMode.DEFAULT);
            Quota globalQuota = (Quota)BDBQuotaStore.this.usedQuotaByTileSetId.get(tx, (Object)BDBQuotaStore.GLOBAL_QUOTA_NAME, LockMode.DEFAULT);
            usedQuota.add(quotaDiff);
            globalQuota.add(quotaDiff);
            BDBQuotaStore.this.usedQuotaById.putNoReturn(tx, (Object)usedQuota);
            BDBQuotaStore.this.usedQuotaById.putNoReturn(tx, (Object)globalQuota);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UsedQuotaByLayerName
    implements Callable<Quota> {
        private final String layerName;

        public UsedQuotaByLayerName(String layerName) {
            this.layerName = layerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Quota call() throws Exception {
            Quota aggregated = null;
            EntityCursor layerTileSetsIds = BDBQuotaStore.this.tileSetsByLayer.entities(null, (Object)this.layerName, true, (Object)this.layerName, true, CursorConfig.DEFAULT);
            try {
                TileSet tileSet;
                while (null != (tileSet = (TileSet)layerTileSetsIds.next())) {
                    if (aggregated == null) {
                        aggregated = new Quota();
                    }
                    Quota tileSetUsedQuota = new UsedQuotaByTileSetId(tileSet.getId()).call();
                    aggregated.add(tileSetUsedQuota);
                }
            }
            finally {
                layerTileSetsIds.close();
            }
            if (aggregated == null) {
                throw new IllegalArgumentException("No such layer: '" + this.layerName + "'");
            }
            return aggregated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteLayer
    implements Callable<Void> {
        private final String layerName;

        public DeleteLayer(String layerName) {
            this.layerName = layerName;
        }

        @Override
        public Void call() throws Exception {
            Transaction transaction = BDBQuotaStore.this.entityStore.getEnvironment().beginTransaction(null, null);
            try {
                this.call(transaction);
                transaction.commit();
            }
            catch (RuntimeException e) {
                transaction.abort();
                throw e;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Transaction transaction) {
            EntityCursor tileSets = BDBQuotaStore.this.tileSetsByLayer.entities(transaction, (Object)this.layerName, true, (Object)this.layerName, true, null);
            try {
                TileSet tileSet;
                while (null != (tileSet = (TileSet)tileSets.next())) {
                    Quota freed = (Quota)BDBQuotaStore.this.usedQuotaByTileSetId.get(transaction, (Object)tileSet.getId(), LockMode.DEFAULT);
                    Quota global = (Quota)BDBQuotaStore.this.usedQuotaByTileSetId.get(transaction, (Object)BDBQuotaStore.GLOBAL_QUOTA_NAME, LockMode.DEFAULT);
                    tileSets.delete();
                    global.subtract(freed.getBytes());
                    BDBQuotaStore.this.usedQuotaById.put(transaction, (Object)global);
                }
            }
            finally {
                tileSets.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UsedQuotaByTileSetId
    implements Callable<Quota> {
        private final String tileSetId;

        private UsedQuotaByTileSetId(String tileSetId) {
            this.tileSetId = tileSetId;
        }

        @Override
        public Quota call() throws Exception {
            Quota quota = (Quota)BDBQuotaStore.this.usedQuotaByTileSetId.get(null, (Object)this.tileSetId, LockMode.READ_COMMITTED);
            if (quota == null) {
                throw new IllegalArgumentException("Used quota for tileSet '" + this.tileSetId + "' does not exist");
            }
            return quota;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetLayerNames
    implements Callable<Set<String>> {
        private GetLayerNames() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> call() throws Exception {
            EntityCursor layerNameCursor = BDBQuotaStore.this.tileSetsByLayer.keys(null, CursorConfig.DEFAULT);
            HashSet<String> names = new HashSet<String>();
            try {
                String name;
                while ((name = (String)layerNameCursor.nextNoDup()) != null) {
                    if (BDBQuotaStore.GLOBAL_QUOTA_NAME.equals(name)) continue;
                    names.add(name);
                }
            }
            finally {
                layerNameCursor.close();
            }
            return names;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartUpInitializer
    implements Callable<Void> {
        private StartUpInitializer() {
        }

        @Override
        public Void call() throws Exception {
            Transaction transaction = BDBQuotaStore.this.entityStore.getEnvironment().beginTransaction(null, null);
            try {
                if (null == BDBQuotaStore.this.usedQuotaByTileSetId.get(transaction, (Object)BDBQuotaStore.GLOBAL_QUOTA_NAME, LockMode.DEFAULT)) {
                    log.debug((Object)"First time run: creating global quota object");
                    TileSet globalTileSet = new TileSet(BDBQuotaStore.GLOBAL_QUOTA_NAME);
                    BDBQuotaStore.this.tileSetById.put(transaction, (Object)globalTileSet);
                    Quota globalQuota = new Quota();
                    globalQuota.setTileSetId(BDBQuotaStore.GLOBAL_QUOTA_NAME);
                    BDBQuotaStore.this.usedQuotaById.put(transaction, (Object)globalQuota);
                    log.debug((Object)"created Global Quota");
                }
                Set<String> layerNames = BDBQuotaStore.this.tilePageCalculator.getLayerNames();
                Object existingLayers = new GetLayerNames().call();
                HashSet layersToDelete = new HashSet(existingLayers);
                layersToDelete.removeAll(layerNames);
                for (String layerName : layersToDelete) {
                    log.info((Object)("Deleting disk quota information for layer '" + layerName + "' as it does not exist anymore..."));
                    try {
                        new DeleteLayer(layerName).call(transaction);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error deleting disk quota information for layer '" + layerName + "'"), (Throwable)e);
                    }
                }
                for (String layerName : layerNames) {
                    Set<TileSet> layerTileSets = BDBQuotaStore.this.tilePageCalculator.getTileSetsFor(layerName);
                    for (TileSet tset : layerTileSets) {
                        BDBQuotaStore.this.getOrCreateTileSet(transaction, tset);
                    }
                }
                transaction.commit();
            }
            catch (RuntimeException e) {
                transaction.abort();
                throw e;
            }
            return null;
        }
    }
}

