/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.CacheCleaner;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;

class CacheCleanerTask
implements Runnable {
    static final Log log = LogFactory.getLog(CacheCleanerTask.class);
    private final Map<String, Future<?>> perLayerRunningCleanUps;
    private Future<?> globalCleanUpTask;
    private ExecutorService cleanUpExecutorService;
    private final DiskQuotaMonitor monitor;

    public CacheCleanerTask(DiskQuotaMonitor monitor, ExecutorService executor) {
        this.monitor = monitor;
        this.cleanUpExecutorService = executor;
        this.perLayerRunningCleanUps = new HashMap();
    }

    public void run() {
        try {
            this.innerRun();
        }
        catch (InterruptedException e) {
            log.info((Object)"CacheCleanerTask called for shut down", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error((Object)"Error running cache diskquota enforcement task", (Throwable)e);
        }
    }

    private void innerRun() throws InterruptedException {
        DiskQuotaConfig quotaConfig = this.monitor.getConfig();
        if (!quotaConfig.isEnabled().booleanValue()) {
            log.trace((Object)"DiskQuota disabled, ignoring run...");
            return;
        }
        quotaConfig.setLastCleanUpTime(new Date());
        Set<String> allLayerNames = this.monitor.getLayerNames();
        Set<String> configuredLayerNames = quotaConfig.layerNames();
        HashSet<String> globallyManagedLayerNames = new HashSet<String>(allLayerNames);
        globallyManagedLayerNames.removeAll(configuredLayerNames);
        for (String layerName : configuredLayerNames) {
            if (this.monitor.isCacheInfoBuilderRunning(layerName)) {
                log.info((Object)("Cache information is still being gathered for layer '" + layerName + "'. Skipping quota enforcement task for this layer."));
                continue;
            }
            Future<?> runningCleanup = this.perLayerRunningCleanUps.get(layerName);
            if (runningCleanup != null && !runningCleanup.isDone()) {
                log.debug((Object)("Cache clean up task still running for layer '" + layerName + "'. Ignoring it for this run."));
                continue;
            }
            LayerQuota definedQuotaForLayer = quotaConfig.layerQuota(layerName);
            ExpirationPolicy policy = definedQuotaForLayer.getExpirationPolicyName();
            Quota quota = definedQuotaForLayer.getQuota();
            Quota usedQuota = this.monitor.getUsedQuotaByLayerName(layerName);
            Quota excedent = usedQuota.difference(quota);
            if (excedent.getBytes().compareTo(BigInteger.ZERO) <= 0) continue;
            log.info((Object)("Layer '" + layerName + "' exceeds its quota of " + quota.toNiceString() + " by " + excedent.toNiceString() + ". Currently used: " + usedQuota.toNiceString() + ". Clean up task will be performed" + " using expiration policy " + (Object)((Object)policy)));
            Set<String> layerNames = Collections.singleton(layerName);
            CacheCleaner.QuotaResolver quotaResolver = this.monitor.newLayerQuotaResolver(layerName);
            LayerQuotaEnforcementTask task = new LayerQuotaEnforcementTask(layerNames, quotaResolver, this.monitor);
            Future<Object> future = this.cleanUpExecutorService.submit(task);
            this.perLayerRunningCleanUps.put(layerName, future);
        }
        if (globallyManagedLayerNames.size() > 0) {
            ExpirationPolicy globalExpirationPolicy = quotaConfig.getGlobalExpirationPolicyName();
            if (globalExpirationPolicy == null) {
                return;
            }
            Quota globalQuota = quotaConfig.getGlobalQuota();
            if (globalQuota == null) {
                log.info((Object)("There's not a global disk quota configured. The following layers will not be checked for excess of disk usage: " + globallyManagedLayerNames));
                return;
            }
            if (this.globalCleanUpTask != null && !this.globalCleanUpTask.isDone()) {
                log.debug((Object)"Global cache quota enforcement task still running, avoiding issueing a new one...");
                return;
            }
            Quota globalUsedQuota = this.monitor.getGloballyUsedQuota();
            Quota excedent = globalUsedQuota.difference(globalQuota);
            if (excedent.getBytes().compareTo(BigInteger.ZERO) > 0) {
                log.info((Object)"Submitting global cache quota enforcement task");
                CacheCleaner.QuotaResolver quotaResolver = this.monitor.newGlobalQuotaResolver();
                LayerQuotaEnforcementTask task = new LayerQuotaEnforcementTask(globallyManagedLayerNames, quotaResolver, this.monitor);
                this.globalCleanUpTask = this.cleanUpExecutorService.submit(task);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Won't launch global quota enforcement task, " + globalUsedQuota.toNiceString() + " used out of " + globalQuota.toNiceString() + " configured for the whole cache size."));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerQuotaEnforcementTask
    implements Callable<Object> {
        private final Set<String> layerNames;
        private final CacheCleaner.QuotaResolver quotaResolver;
        private final DiskQuotaMonitor monitor;

        public LayerQuotaEnforcementTask(Set<String> layerNames, CacheCleaner.QuotaResolver quotaResolver, DiskQuotaMonitor monitor) {
            this.layerNames = layerNames;
            this.quotaResolver = quotaResolver;
            this.monitor = monitor;
        }

        @Override
        public Object call() throws Exception {
            try {
                this.monitor.expireByLayerNames(this.layerNames, this.quotaResolver);
            }
            catch (InterruptedException e) {
                log.info((Object)"Layer quota enforcement task terminated prematurely");
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

