/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.DiskQuotaConfigPanel;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCSettingsPage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger(GWCSettingsPage.class);

    public GWCSettingsPage() {
        this.setHeaderPanel(this.headerPanel());
        boolean diskQuotaDisabled = this.getGWC().getDisQuotaConfig() == null;
        Form form = new Form("form");
        this.add(new Component[]{form});
        LoadableDetachableModel<WMSInfo> wmsInfoModel = new LoadableDetachableModel<WMSInfo>(){
            private static final long serialVersionUID = 1L;

            public WMSInfo load() {
                return (WMSInfo)GWCSettingsPage.this.getGeoServer().getService(WMSInfo.class);
            }
        };
        LoadableDetachableModel<DiskQuotaConfig> diskQuotaModel = new LoadableDetachableModel<DiskQuotaConfig>(){
            private static final long serialVersionUID = 1L;

            protected DiskQuotaConfig load() {
                GWC gwc = GWCSettingsPage.this.getGWC();
                DiskQuotaConfig quotaConfig = gwc.getDisQuotaConfig();
                if (quotaConfig == null) {
                    quotaConfig = new DiskQuotaConfig();
                    quotaConfig.setDefaults();
                }
                return quotaConfig;
            }
        };
        LoadableDetachableModel<GWC> gwcModel = new LoadableDetachableModel<GWC>(){
            private static final long serialVersionUID = 1L;

            protected GWC load() {
                return GWCSettingsPage.this.getGWC();
            }
        };
        PropertyModel metadataModel = new PropertyModel((Object)wmsInfoModel, "metadata");
        MapModel wmsIntegrationEnabledModel = new MapModel((IModel)metadataModel, "GWC_WMS_Integration");
        CheckBox wmsIntegration = GWCSettingsPage.checkbox("enableWMSIntegration", (IModel<Boolean>)wmsIntegrationEnabledModel, "GWCSettingsPage.enableWMSIntegration.title");
        form.add(new Component[]{wmsIntegration});
        DiskQuotaConfig diskQuotaConfig = (DiskQuotaConfig)diskQuotaModel.getObject();
        Quota globalQuota = diskQuotaConfig.getGlobalQuota();
        if (globalQuota == null) {
            LOGGER.info("There's no GWC global disk quota configured, setting a default of 100MiB");
            globalQuota = new Quota(100.0, StorageUnit.MiB);
            diskQuotaConfig.setGlobalQuota(globalQuota);
        }
        BigInteger bytes = globalQuota.getBytes();
        StorageUnit bestRepresentedUnit = StorageUnit.bestFit((BigInteger)bytes);
        BigDecimal transformedQuota = StorageUnit.B.convertTo(new BigDecimal(bytes), bestRepresentedUnit);
        Model configQuotaValueModel = new Model((Serializable)Double.valueOf(transformedQuota.doubleValue()));
        Model configQuotaUnitModel = new Model((Serializable)bestRepresentedUnit);
        DiskQuotaConfigPanel diskQuotaConfigPanel = new DiskQuotaConfigPanel("diskQuotaConfigPanel", form, (IModel<DiskQuotaConfig>)diskQuotaModel, (IModel<GWC>)gwcModel, (IModel<Double>)configQuotaValueModel, (IModel<StorageUnit>)configQuotaUnitModel);
        if (diskQuotaDisabled) {
            diskQuotaConfigPanel.setVisible(false);
        }
        form.add(new Component[]{diskQuotaConfigPanel});
        form.add(new Component[]{new Button("submit", (IModel)wmsInfoModel, diskQuotaDisabled, (IModel)configQuotaUnitModel, (IModel)configQuotaValueModel, form){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$wmsInfoModel;
            final /* synthetic */ boolean val$diskQuotaDisabled;
            final /* synthetic */ IModel val$configQuotaUnitModel;
            final /* synthetic */ IModel val$configQuotaValueModel;
            final /* synthetic */ Form val$form;
            {
                this.val$wmsInfoModel = iModel;
                this.val$diskQuotaDisabled = bl;
                this.val$configQuotaUnitModel = iModel2;
                this.val$configQuotaValueModel = iModel3;
                this.val$form = form;
                super(x0);
            }

            public void onSubmit() {
                Double chosenQuota;
                GeoServer gs = GWCSettingsPage.this.getGeoServer();
                WMSInfo wmsInfo = (WMSInfo)this.val$wmsInfoModel.getObject();
                gs.save((ServiceInfo)wmsInfo);
                if (this.val$diskQuotaDisabled) {
                    this.setResponsePage(GeoServerHomePage.class);
                    return;
                }
                GWC gwc = GWCSettingsPage.this.getGWC();
                StorageUnit chosenUnit = (StorageUnit)this.val$configQuotaUnitModel.getObject();
                String chosenQuotaStr = String.valueOf(this.val$configQuotaValueModel.getObject());
                try {
                    chosenQuota = Double.valueOf(chosenQuotaStr);
                }
                catch (NumberFormatException e) {
                    this.val$form.error((Serializable)((Object)(chosenQuotaStr + " is not a valid floating point number")));
                    return;
                }
                if (chosenQuota <= 0.0) {
                    this.val$form.error((Serializable)((Object)"Quota has to be > 0"));
                    return;
                }
                gwc.getGlobalQuota().setValue(chosenQuota.doubleValue(), chosenUnit);
                gwc.saveDiskQuotaConfig();
                this.setResponsePage(GeoServerHomePage.class);
            }
        }});
        form.add(new Component[]{new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        }});
    }

    private GWC getGWC() {
        GWC gwc = (GWC)this.getGeoServerApplication().getBean("gwcFacade");
        return gwc;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        return header;
    }

    static CheckBox checkbox(String id, IModel<Boolean> model, String titleKey) {
        CheckBox checkBox = new CheckBox(id, model);
        if (null != titleKey) {
            checkBox.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new StringResourceModel(titleKey, (Component)null, null))});
        }
        return checkBox;
    }
}

