/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.crs;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.wicket.markup.html.WebResource;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.ValueMap;
import org.geoserver.web.crs.CRSAreaOfValidityMapBuilder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DynamicCrsMapResource
extends WebResource {
    private static final long serialVersionUID = 1L;
    private final CoordinateReferenceSystem crs;

    public DynamicCrsMapResource(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public IResourceStream getResourceStream() {
        ValueMap parameters = this.getParameters();
        int width = parameters.getInt("WIDTH", 400);
        int height = parameters.getInt("HEIGHT", 200);
        String bboxStr = parameters.getString("BBOX");
        ByteArrayOutputStream output = null;
        if (bboxStr != null) {
            try {
                CRSAreaOfValidityMapBuilder builder = new CRSAreaOfValidityMapBuilder(width, height);
                Envelope envelope = this.parseEnvelope(bboxStr);
                RenderedImage image = builder.createMapFor(this.crs, envelope);
                output = new ByteArrayOutputStream();
                ImageIO.write(image, "PNG", output);
            }
            catch (Exception e) {
                output = null;
                e.printStackTrace();
            }
        }
        byte[] byteArray = output == null ? null : output.toByteArray();
        return new ByteArrayResourceStream(byteArray);
    }

    private Envelope parseEnvelope(String bboxStr) {
        String[] split = bboxStr.split(",");
        double minx = Double.valueOf(split[0]);
        double miny = Double.valueOf(split[1]);
        double maxx = Double.valueOf(split[2]);
        double maxy = Double.valueOf(split[3]);
        return new Envelope(minx, maxx, miny, maxy);
    }

    private static class ByteArrayResourceStream
    implements IResourceStream {
        private static final long serialVersionUID = 1L;
        private final byte[] content;

        public ByteArrayResourceStream(byte[] content) {
            this.content = content;
        }

        public void setLocale(Locale arg0) {
        }

        public long length() {
            return this.content == null ? 0L : (long)this.content.length;
        }

        public Locale getLocale() {
            return null;
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            if (this.content == null) {
                throw new ResourceStreamNotFoundException();
            }
            return new ByteArrayInputStream(this.content);
        }

        public String getContentType() {
            return "image/png";
        }

        public void close() throws IOException {
        }

        public Time lastModifiedTime() {
            return null;
        }
    }
}

