/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.PageInfo;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class WorkspaceResource
extends AbstractCatalogResource {
    public WorkspaceResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, WorkspaceInfo.class, catalog);
    }

    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new WorkspaceHTMLFormat(request, response, (Resource)this, this.catalog);
    }

    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeWorkspace(WorkspaceInfo ws, HierarchicalStreamWriter writer, MarshallingContext context) {
                PageInfo pg = WorkspaceResource.this.getPageInfo();
                writer.startNode("dataStores");
                WorkspaceResource.this.encodeCollectionLink("datastores", writer);
                writer.endNode();
                writer.startNode("coverageStores");
                WorkspaceResource.this.encodeCollectionLink("coveragestores", writer);
                writer.endNode();
                writer.startNode("wmsStores");
                WorkspaceResource.this.encodeCollectionLink("wmsstores", writer);
                writer.endNode();
            }
        });
    }

    public boolean allowGet() {
        return this.getAttribute("workspace") != null;
    }

    protected Object handleObjectGet() {
        String ws = this.getAttribute("workspace");
        LOGGER.fine("GET workspace " + ws);
        return this.catalog.getWorkspaceByName(ws);
    }

    public boolean allowPost() {
        return this.getAttribute("workspace") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        WorkspaceInfo workspace = (WorkspaceInfo)object;
        this.catalog.add(workspace);
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            LOGGER.fine("Automatically creating namespace for workspace " + workspace.getName());
            namespace = this.catalog.getFactory().createNamespace();
            namespace.setPrefix(workspace.getName());
            namespace.setURI("http://" + workspace.getName());
            this.catalog.add(namespace);
        }
        LOGGER.info("POST workspace " + workspace.getName());
        return workspace.getName();
    }

    public boolean allowPut() {
        return this.getAttribute("workspace") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        WorkspaceInfo workspace = (WorkspaceInfo)object;
        String ws = this.getAttribute("workspace");
        if ("default".equals(ws)) {
            this.catalog.setDefaultWorkspace(workspace);
        } else {
            WorkspaceInfo original = this.catalog.getWorkspaceByName(ws);
            if (workspace.getName() != null && !workspace.getName().equals(original.getName())) {
                throw new RestletException("Can't change the name of a workspace.", Status.CLIENT_ERROR_FORBIDDEN);
            }
            new CatalogBuilder(this.catalog).updateWorkspace(original, workspace);
            this.catalog.save(original);
        }
        LOGGER.info("PUT workspace " + ws);
    }

    public boolean allowDelete() {
        return this.getAttribute("workspace") != null && !"default".equals(this.getAttribute("workspace"));
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspace);
        if (!recurse) {
            if (!this.catalog.getStoresByWorkspace(ws, StoreInfo.class).isEmpty()) {
                throw new RestletException("Workspace not empty", Status.CLIENT_ERROR_FORBIDDEN);
            }
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws.getName());
            if (ns != null) {
                if (!this.catalog.getFeatureTypesByNamespace(ns).isEmpty()) {
                    throw new RestletException("Namespace for workspace not empty.", Status.CLIENT_ERROR_FORBIDDEN);
                }
                this.catalog.remove(ns);
            }
            this.catalog.remove(ws);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(ws);
        }
        LOGGER.info("DELETE workspace " + ws);
    }

    static class WorkspaceHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        Catalog catalog;

        public WorkspaceHTMLFormat(Request request, Response response, Resource resource, Catalog catalog) {
            super(WorkspaceInfo.class, request, response, resource);
            this.catalog = catalog;
        }

        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<WorkspaceInfo>(WorkspaceInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, WorkspaceInfo object) {
                    List dataStores = WorkspaceHTMLFormat.this.catalog.getStoresByWorkspace(object, DataStoreInfo.class);
                    properties.put("dataStores", new CollectionModel((Collection)dataStores, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)WorkspaceHTMLFormat.this, DataStoreInfo.class)));
                    List coverageStores = WorkspaceHTMLFormat.this.catalog.getStoresByWorkspace(object, CoverageStoreInfo.class);
                    properties.put("coverageStores", new CollectionModel((Collection)coverageStores, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)WorkspaceHTMLFormat.this, CoverageStoreInfo.class)));
                    List wmsStores = WorkspaceHTMLFormat.this.catalog.getStoresByWorkspace(object, WMSStoreInfo.class);
                    properties.put("wmsStores", new CollectionModel((Collection)wmsStores, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)WorkspaceHTMLFormat.this, WMSStoreInfo.class)));
                    properties.put("isDefault", object.equals(WorkspaceHTMLFormat.this.catalog.getDefaultWorkspace()));
                }
            });
            return cfg;
        }
    }
}

