/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.NamespaceListResource;
import org.geoserver.catalog.rest.NamespaceResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class NamespaceFinder
extends AbstractCatalogFinder {
    public NamespaceFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String namespace = this.getAttribute(request, "namespace");
        if (namespace == null && request.getMethod() == Method.GET) {
            return new NamespaceListResource(this.getContext(), request, response, this.catalog);
        }
        if (namespace != null && this.catalog.getNamespaceByPrefix(namespace) == null) {
            throw new RestletException("No such namespace: " + namespace, Status.CLIENT_ERROR_NOT_FOUND);
        }
        return new NamespaceResource(null, request, response, this.catalog);
    }
}

