/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.DataStoreListResource;
import org.geoserver.catalog.rest.DataStoreResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class DataStoreFinder
extends AbstractCatalogFinder {
    public DataStoreFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = this.getAttribute(request, "workspace");
        String ds = this.getAttribute(request, "datastore");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (ds != null && this.catalog.getDataStoreByName(ws, ds) == null && !"default".equals(ds)) {
            throw new RestletException("No such datastore: " + ws + "," + ds, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (ds == null && request.getMethod() == Method.GET) {
            return new DataStoreListResource(this.getContext(), request, response, this.catalog);
        }
        return new DataStoreResource(null, request, response, this.catalog);
    }
}

