/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.media.jai.PlanarImage;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.ImageUtils;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.resources.image.ImageUtilities;
import org.springframework.util.Assert;

public abstract class RenderedImageMapResponse
extends AbstractMapResponse {
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    protected final WMS wms;

    public RenderedImageMapResponse(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public RenderedImageMapResponse(String mime, WMS wms) {
        super(RenderedImageMap.class, mime);
        this.wms = wms;
    }

    public RenderedImageMapResponse(String[] outputFormats, WMS wms) {
        super(RenderedImageMap.class, outputFormats);
        this.wms = wms;
    }

    public abstract void formatImageOutputStream(RenderedImage var1, OutputStream var2, WMSMapContext var3) throws ServiceException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(RenderedImageMap.class, (Object)value);
        RenderedImageMap imageMap = (RenderedImageMap)value;
        try {
            RenderedImage image = imageMap.getImage();
            List<GridCoverage2D> renderedCoverages = imageMap.getRenderedCoverages();
            WMSMapContext mapContext = imageMap.getMapContext();
            try {
                this.formatImageOutputStream(image, output, mapContext);
                output.flush();
            }
            finally {
                for (GridCoverage2D coverage : renderedCoverages) {
                    coverage.dispose(true);
                }
                if (image instanceof PlanarImage) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)image));
                } else if (image instanceof BufferedImage) {
                    ((BufferedImage)image).flush();
                }
            }
        }
        finally {
            imageMap.dispose();
        }
    }

    protected RenderedImage forceIndexed8Bitmask(RenderedImage originalImage, InverseColorMapOp paletteInverter) {
        return ImageUtils.forceIndexed8Bitmask(originalImage, paletteInverter);
    }
}

