/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.decoration.MetatiledMapDecorationLayout;
import org.geoserver.wms.decoration.WatermarkDecoration;
import org.geoserver.wms.map.AbstractMapOutputFormat;
import org.geoserver.wms.map.ImageUtils;
import org.geoserver.wms.map.KMLStyleFilteringVisitor;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.PaletteExtractor;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderingTimeoutEnforcer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.geometry.BoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedImageMapOutputFormat
extends AbstractMapOutputFormat {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List<String> AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    private static final int KB = 1024;
    private static LookupTableJAI IDENTITY_TABLE = new LookupTableJAI(RenderedImageMapOutputFormat.getTable());
    private static final Logger LOGGER = Logging.getLogger(RenderedImageMapOutputFormat.class);
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    protected final WMS wms;
    private boolean palleteSupported = true;
    private boolean transparencySupported = true;

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public RenderedImageMapOutputFormat(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public RenderedImageMapOutputFormat(String mime, WMS wms) {
        super(mime);
        this.wms = wms;
    }

    public RenderedImageMapOutputFormat(String mime, String[] outputFormats, WMS wms) {
        super(mime, outputFormats);
        this.wms = wms;
    }

    @Override
    public final RenderedImageMap produceMap(WMSMapContext mapContext) throws ServiceException {
        return this.produceMap(mapContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImageMap produceMap(WMSMapContext mapContext, boolean tiled) throws ServiceException {
        RenderingTimeoutEnforcer timeout;
        int maxRenderingTime;
        RenderExceptionStrategy nonIgnorableExceptionListener;
        MaxErrorEnforcer errorChecker;
        int maxErrors;
        RenderedImage preparedImage;
        RenderedImage image;
        IndexColorModel palette;
        block42: {
            ShapefileRenderer renderer;
            GetMapRequest request;
            String antialias;
            System.setProperty("tolerance", "0.333");
            MapDecorationLayout layout = this.findDecorationLayout(mapContext, tiled);
            Rectangle paintArea = new Rectangle(0, 0, mapContext.getMapWidth(), mapContext.getMapHeight());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setting up " + paintArea.width + "x" + paintArea.height + " image");
            }
            if ((antialias = (String)(request = mapContext.getRequest()).getFormatOptions().get("antialias")) != null) {
                antialias = antialias.toUpperCase();
            }
            palette = null;
            InverseColorMapOp paletteInverter = mapContext.getPaletteInverter();
            boolean transparent = mapContext.isTransparent() && this.isTransparencySupported();
            Color bgColor = mapContext.getBgColor();
            if (paletteInverter != null && AA_NONE.equals(antialias)) {
                palette = paletteInverter.getIcm();
            } else if (AA_NONE.equals(antialias)) {
                PaletteExtractor pe = new PaletteExtractor(transparent ? null : bgColor);
                MapLayer[] layers = mapContext.getLayers();
                for (int i = 0; i < layers.length; ++i) {
                    pe.visit(layers[i].getStyle());
                    if (!pe.canComputePalette()) break;
                }
                if (pe.canComputePalette()) {
                    palette = pe.getPalette();
                }
            }
            long maxMemory = this.wms.getMaxRequestMemory() * 1024;
            long memory = this.getDrawingSurfaceMemoryUse(paintArea.width, paintArea.height, palette, transparent);
            StreamingRenderer testRenderer = new StreamingRenderer();
            testRenderer.setContext((MapContext)mapContext);
            if (maxMemory > 0L && (memory += (long)testRenderer.getMaxBackBufferMemory(paintArea.width, paintArea.height)) > maxMemory) {
                long kbUsed = memory / 1024L;
                long kbMax = maxMemory / 1024L;
                throw new ServiceException("Rendering request would use " + kbUsed + "KB, whilst the " + "maximum memory allowed is " + kbMax + "KB");
            }
            image = null;
            if (DefaultWebMapService.isDirectRasterPathEnabled() && mapContext.getLayerCount() == 1 && mapContext.getAngle() == 0.0 && (layout == null || layout.isEmpty())) {
                ArrayList<GridCoverage2D> renderedCoverages = new ArrayList<GridCoverage2D>(2);
                try {
                    image = this.directRasterRender(mapContext, 0, renderedCoverages);
                }
                catch (Exception e) {
                    throw new ServiceException("Error rendering coverage on the fast path", (Throwable)e);
                }
                if (image != null) {
                    RenderedImageMap result = new RenderedImageMap(mapContext, image, this.getMimeType());
                    result.setRenderedCoverages(renderedCoverages);
                    return result;
                }
            }
            boolean useAlpha = transparent || MetatileMapOutputFormat.isRequestTiled(request, this);
            preparedImage = this.prepareImage(paintArea.width, paintArea.height, palette, useAlpha);
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            Graphics2D graphic = ImageUtils.prepareTransparency(transparent, bgColor, preparedImage, hintsMap);
            if (AA_NONE.equals(antialias)) {
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (preparedImage.getColorModel() instanceof IndexColorModel) {
                    hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                }
            } else if (AA_TEXT.equals(antialias)) {
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                if (antialias != null && !AA_FULL.equals(antialias)) {
                    LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + AA_SETTINGS);
                }
                hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hintsMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            if (this.wms != null) {
                if (WMSInfo.WMSInterpolation.Nearest.equals((Object)this.wms.getInterpolation())) {
                    hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
                    hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else if (WMSInfo.WMSInterpolation.Bilinear.equals((Object)this.wms.getInterpolation())) {
                    hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
                    hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                } else if (WMSInfo.WMSInterpolation.Bicubic.equals((Object)this.wms.getInterpolation())) {
                    hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
                    hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                }
            }
            graphic.setRenderingHints(hintsMap);
            RenderingHints hints = new RenderingHints(hintsMap);
            if (DefaultWebMapService.useShapefileRenderer()) {
                renderer = new ShapefileRenderer();
            } else {
                StreamingRenderer sr = new StreamingRenderer();
                sr.setThreadPool(DefaultWebMapService.getRenderingPool());
                renderer = sr;
            }
            renderer.setContext((MapContext)mapContext);
            renderer.setJava2DHints(hints);
            HashMap<String, Object> rendererParams = new HashMap<String, Object>();
            rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
            rendererParams.put("renderingBuffer", new Integer(mapContext.getBuffer()));
            rendererParams.put("maxFiltersToSendToDatastore", DefaultWebMapService.getMaxFilterRules());
            rendererParams.put("scaleComputationMethod", "OGC");
            if (AA_NONE.equals(antialias)) {
                rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_STRING);
            } else {
                rendererParams.put("textRenderingMethod", StreamingRenderer.TEXT_RENDERING_ADAPTIVE);
            }
            if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
                rendererParams.put("lineWidthOptimization", true);
            }
            rendererParams.put("advancedProjectionHandling", true);
            if (DefaultWebMapService.isContinuousMapWrappingEnabled()) {
                rendererParams.put("continuousMapWrapping", true);
            }
            if (mapContext.getRequest().getFormatOptions().get("dpi") != null) {
                rendererParams.put("dpi", (Integer)mapContext.getRequest().getFormatOptions().get("dpi"));
            }
            boolean kmplacemark = false;
            if (mapContext.getRequest().getFormatOptions().get("kmplacemark") != null) {
                kmplacemark = (Boolean)mapContext.getRequest().getFormatOptions().get("kmplacemark");
            }
            if (kmplacemark) {
                KMLStyleFilteringVisitor dupVisitor = new KMLStyleFilteringVisitor();
                MapLayer[] layers = mapContext.getLayers();
                for (int i = 0; i < layers.length; ++i) {
                    Style style = layers[i].getStyle();
                    style.accept((StyleVisitor)dupVisitor);
                    Style copy = (Style)dupVisitor.getCopy();
                    layers[i].setStyle(copy);
                }
            }
            renderer.setRendererHints(rendererParams);
            maxErrors = this.wms.getMaxRenderingErrors();
            errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
            nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
            renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
            maxRenderingTime = this.wms.getMaxRenderingTime() * 1000;
            timeout = new RenderingTimeoutEnforcer(maxRenderingTime, (GTRenderer)renderer, graphic);
            timeout.start();
            try {
                renderer.paint(graphic, paintArea, mapContext.getRenderingArea(), mapContext.getRenderingTransform());
                if (layout == null) break block42;
                try {
                    layout.paint(graphic, paintArea, mapContext);
                }
                catch (Exception e) {
                    throw new ServiceException("Problem occurred while trying to watermark data", (Throwable)e);
                }
            }
            finally {
                timeout.stop();
                graphic.dispose();
            }
        }
        if (timeout.isTimedOut()) {
            throw new ServiceException("This requested used more time than allowed and has been forcefully stopped. Max rendering time is " + (double)maxRenderingTime / 1000.0 + "s");
        }
        if (nonIgnorableExceptionListener.exceptionOccurred()) {
            Exception renderError = nonIgnorableExceptionListener.getException();
            throw new ServiceException("Rendering process failed", (Throwable)renderError, "internalError");
        }
        if (errorChecker.exceedsMaxErrors()) {
            throw new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out.", (Throwable)errorChecker.getLastException(), "internalError");
        }
        image = palette != null && palette.getMapSize() < 256 ? RenderedImageMapOutputFormat.optimizeSampleModel(preparedImage) : preparedImage;
        RenderedImageMap map = new RenderedImageMap(mapContext, image, this.getMimeType());
        return map;
    }

    protected MapDecorationLayout findDecorationLayout(WMSMapContext mapContext, boolean tiled) {
        MapDecorationLayout.Block watermark;
        String layoutName = null;
        if (mapContext.getRequest().getFormatOptions() != null) {
            layoutName = (String)mapContext.getRequest().getFormatOptions().get("layout");
        }
        MapDecorationLayout layout = null;
        if (layoutName != null) {
            try {
                File layoutDir = GeoserverDataDirectory.findConfigDir((File)GeoserverDataDirectory.getGeoserverDataDirectory(), (String)"layouts");
                if (layoutDir != null) {
                    File layoutConfig = new File(layoutDir, layoutName + ".xml");
                    if (layoutConfig.exists() && layoutConfig.canRead()) {
                        layout = MapDecorationLayout.fromFile(layoutConfig, tiled);
                    } else {
                        LOGGER.log(Level.WARNING, "Unknown layout requested: " + layoutName);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "No layout directory defined");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to load layout: " + layoutName, e);
            }
        }
        if (layout == null) {
            MapDecorationLayout mapDecorationLayout = layout = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        }
        if ((watermark = RenderedImageMapOutputFormat.getWatermark(this.wms.getServiceInfo())) != null) {
            layout.addBlock(watermark);
        }
        return layout;
    }

    public static MapDecorationLayout.Block getWatermark(WMSInfo wms) {
        WatermarkInfo watermark;
        WatermarkInfo watermarkInfo = watermark = wms == null ? null : wms.getWatermark();
        if (watermark != null && watermark.isEnabled()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("url", watermark.getURL());
            options.put("opacity", Float.toString((255.0f - (float)watermark.getTransparency()) / 2.55f));
            WatermarkDecoration d = new WatermarkDecoration();
            try {
                d.loadOptions(options);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Couldn't construct watermark from configuration", e);
                throw new ServiceException((Throwable)e);
            }
            MapDecorationLayout.Block.Position p = null;
            switch (watermark.getPosition()) {
                case TOP_LEFT: {
                    p = MapDecorationLayout.Block.Position.UL;
                    break;
                }
                case TOP_CENTER: {
                    p = MapDecorationLayout.Block.Position.UC;
                    break;
                }
                case TOP_RIGHT: {
                    p = MapDecorationLayout.Block.Position.UR;
                    break;
                }
                case MID_LEFT: {
                    p = MapDecorationLayout.Block.Position.CL;
                    break;
                }
                case MID_CENTER: {
                    p = MapDecorationLayout.Block.Position.CC;
                    break;
                }
                case MID_RIGHT: {
                    p = MapDecorationLayout.Block.Position.CR;
                    break;
                }
                case BOT_LEFT: {
                    p = MapDecorationLayout.Block.Position.LL;
                    break;
                }
                case BOT_CENTER: {
                    p = MapDecorationLayout.Block.Position.LC;
                    break;
                }
                case BOT_RIGHT: {
                    p = MapDecorationLayout.Block.Position.LR;
                    break;
                }
                default: {
                    throw new ServiceException("Unknown WatermarkInfo.Position value.  Something is seriously wrong.");
                }
            }
            return new MapDecorationLayout.Block(d, p, null, new Point(0, 0));
        }
        return null;
    }

    protected final RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.createImage(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    public boolean isTransparencySupported() {
        return this.transparencySupported;
    }

    public void setTransparencySupported(boolean supportsTransparency) {
        this.transparencySupported = supportsTransparency;
    }

    public boolean isPaletteSupported() {
        return this.palleteSupported;
    }

    public void setPaletteSupported(boolean supportsPalette) {
        this.palleteSupported = supportsPalette;
    }

    protected long getDrawingSurfaceMemoryUse(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.getDrawingSurfaceMemoryUse(width, height, this.isPaletteSupported() ? palette : null, transparent && this.isTransparencySupported());
    }

    private static RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)IDENTITY_TABLE, (RenderingHints)hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage directRasterRender(WMSMapContext mapContext, int layerIndex, List<GridCoverage2D> renderedCoverages) throws IOException {
        ReferencedEnvelope bufferedEnvelope;
        Rectangle bufferedTargetArea;
        boolean sameCRS;
        int tileSizeX;
        int tileSizeY;
        List<RasterSymbolizer> symbolizers = RenderedImageMapOutputFormat.getRasterSymbolizers(mapContext, 0);
        if (symbolizers.size() != 1) {
            return null;
        }
        RasterSymbolizer symbolizer = symbolizers.get(0);
        Feature feature = mapContext.getLayer(0).getFeatureSource().getFeatures().features().next();
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)feature.getProperty("grid").getValue();
        Object params = feature.getProperty("params").getValue();
        if (mapContext.getTileSize() != -1) {
            tileSizeX = tileSizeY = mapContext.getTileSize();
        } else {
            tileSizeX = mapContext.getMapWidth();
            tileSizeY = mapContext.getMapHeight();
        }
        int mapWidth = mapContext.getMapWidth();
        int mapHeight = mapContext.getMapHeight();
        ReferencedEnvelope mapEnvelope = mapContext.getAreaOfInterest();
        CoordinateReferenceSystem mapCRS = mapContext.getCoordinateReferenceSystem();
        Rectangle mapRasterArea = new Rectangle(0, 0, mapWidth, mapHeight);
        AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapEnvelope, (Rectangle)mapRasterArea);
        boolean transparent = mapContext.isTransparent() && this.isTransparencySupported();
        Color bgColor = mapContext.getBgColor();
        bgColor = transparent ? new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0) : new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255);
        Interpolation interpolation = Interpolation.getInstance((int)0);
        if (this.wms != null) {
            if (WMSInfo.WMSInterpolation.Nearest.equals((Object)this.wms.getInterpolation())) {
                interpolation = Interpolation.getInstance((int)0);
            } else if (WMSInfo.WMSInterpolation.Bilinear.equals((Object)this.wms.getInterpolation())) {
                interpolation = Interpolation.getInstance((int)1);
            } else if (WMSInfo.WMSInterpolation.Bicubic.equals((Object)this.wms.getInterpolation())) {
                interpolation = Interpolation.getInstance((int)2);
            }
        }
        CoordinateReferenceSystem coverageCRS = reader.getCrs();
        boolean equalsMetadata = CRS.equalsIgnoreMetadata((Object)mapCRS, (Object)coverageCRS);
        try {
            sameCRS = equalsMetadata ? true : CRS.findMathTransform((CoordinateReferenceSystem)mapCRS, (CoordinateReferenceSystem)coverageCRS, (boolean)true).isIdentity();
        }
        catch (FactoryException e1) {
            IOException ioe = new IOException();
            ioe.initCause(e1);
            throw ioe;
        }
        if (sameCRS) {
            GridGeometry2D readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(mapRasterArea), (org.opengis.geometry.Envelope)mapEnvelope);
            bufferedTargetArea = null;
            bufferedEnvelope = null;
        } else {
            bufferedTargetArea = (Rectangle)mapRasterArea.clone();
            bufferedTargetArea.add(mapRasterArea.x + mapRasterArea.width + 10, mapRasterArea.y + mapRasterArea.height + 10);
            bufferedTargetArea.add(mapRasterArea.x - 10, mapRasterArea.y - 10);
            GridToEnvelopeMapper ge = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(mapRasterArea), (org.opengis.geometry.Envelope)mapEnvelope);
            GridGeometry2D readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(bufferedTargetArea), PixelInCell.CELL_CORNER, ge.createTransform(), mapCRS, null);
            bufferedEnvelope = new ReferencedEnvelope((org.opengis.geometry.Envelope)readGG.getEnvelope2D());
        }
        RenderedImage image = null;
        try {
            Color readerBgColor = transparent ? null : bgColor;
            GridCoverage2D coverage = sameCRS ? RenderedImageMapOutputFormat.readBestCoverage(reader, params, mapEnvelope, mapRasterArea, interpolation, readerBgColor) : RenderedImageMapOutputFormat.readBestCoverage(reader, params, bufferedEnvelope, bufferedTargetArea, interpolation, readerBgColor);
            try {
                if (coverage == null) {
                    image = RenderedImageMapOutputFormat.createBkgImage(mapWidth, mapHeight, bgColor, null);
                } else {
                    GridCoverageRenderer gcr = sameCRS ? new GridCoverageRenderer(mapCRS, (Envelope)mapEnvelope, mapRasterArea, worldToScreen, new RenderingHints(JAI.KEY_INTERPOLATION, interpolation)) : new GridCoverageRenderer(mapCRS, bufferedEnvelope, bufferedTargetArea, worldToScreen, new RenderingHints(JAI.KEY_INTERPOLATION, interpolation));
                    image = gcr.renderImage(coverage, symbolizer, interpolation, mapContext.getBgColor(), tileSizeX, tileSizeY);
                }
            }
            finally {
                if (coverage != null) {
                    renderedCoverages.add(coverage);
                }
            }
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
        if (image == null) {
            return null;
        }
        Rectangle imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds();
        ImageLayout layout = new ImageLayout();
        layout.setMinX(0);
        layout.setMinY(0);
        layout.setWidth(mapWidth);
        layout.setHeight(mapHeight);
        layout.setTileGridXOffset(0);
        layout.setTileGridYOffset(0);
        layout.setTileWidth(tileSizeX);
        layout.setTileHeight(tileSizeY);
        ColorModel cm = image.getColorModel();
        double[] bgValues = null;
        PlanarImage[] alphaChannels = null;
        ImageWorker worker = new ImageWorker(image);
        int transparencyType = cm.getTransparency();
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            int bgColorIndex = transparent ? icm.getTransparentPixel() : ColorUtilities.findColorIndex((Color)bgColor, (IndexColorModel)icm);
            if (bgColorIndex == -1) {
                image = worker.forceComponentColorModel().getRenderedImage();
                if (transparent) {
                    image = this.addAlphaChannel(image);
                    worker.setImage(image);
                }
                bgValues = new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), transparent ? 0.0 : 255.0};
                cm = image.getColorModel();
            } else {
                bgValues = new double[]{bgColorIndex};
            }
            if (cm.hasAlpha()) {
                worker.forceComponentColorModel();
                RenderedImage alpha = worker.retainLastBand().getRenderedImage();
                alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
            }
        }
        if (cm instanceof ComponentColorModel) {
            RenderedImage alpha;
            ImageWorker iw;
            ComponentColorModel ccm = (ComponentColorModel)cm;
            boolean hasAlpha = cm.hasAlpha();
            if (ccm.getNumColorComponents() == 1) {
                if (!RenderedImageMapOutputFormat.isLevelOfGray(bgColor) && !transparent || ccm.getTransferType() == 5 || ccm.getTransferType() == 4 || ccm.getTransferType() == 32) {
                    iw = new ImageWorker(image);
                    if (hasAlpha) {
                        alpha = iw.retainLastBand().getRenderedImage();
                        RenderedImage gray = new ImageWorker(image).retainFirstBand().getRenderedImage();
                        image = new ImageWorker(gray).bandMerge(3).addBand(alpha, false).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    } else {
                        image = iw.bandMerge(3).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    }
                } else if (!hasAlpha) {
                    if (transparent) {
                        image = this.addAlphaChannel(image);
                        bgValues = new double[]{this.mapToGrayColor(bgColor, ccm), 0.0};
                    } else {
                        bgValues = new double[]{this.mapToGrayColor(bgColor, ccm)};
                    }
                } else {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = transparent ? new double[]{this.mapToGrayColor(bgColor, ccm), 0.0} : new double[]{this.mapToGrayColor(bgColor, ccm), 255.0};
                }
                cm = image.getColorModel();
                ccm = (ComponentColorModel)cm;
                hasAlpha = cm.hasAlpha();
            }
            if (bgValues == null) {
                if (hasAlpha) {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = transparent ? new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0.0} : new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255.0};
                } else if (transparent) {
                    image = this.addAlphaChannel(image);
                    bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                } else {
                    bgValues = new double[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()};
                }
            }
        }
        if (!imageBounds.contains(mapRasterArea) && !imageBounds.equals(mapRasterArea) || transparencyType != 1) {
            ROI[] rois = new ROI[]{new ROIShape((Shape)imageBounds)};
            double[][] thresholds = new double[][]{{ColorUtilities.getThreshold((int)image.getSampleModel().getDataType())}};
            image = MosaicDescriptor.create((RenderedImage[])new RenderedImage[]{image}, (MosaicType)(alphaChannels != null && transparencyType == 3 ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY), (PlanarImage[])alphaChannels, (ROI[])rois, (double[][])thresholds, (double[])bgValues, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        } else if (imageBounds.contains(mapRasterArea) && !imageBounds.equals(mapRasterArea)) {
            image = CropDescriptor.create((RenderedImage)image, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(mapWidth), (Float)Float.valueOf(mapHeight), null);
        }
        return image;
    }

    private RenderedImage addAlphaChannel(RenderedImage image) {
        ImageLayout tempLayout = new ImageLayout(image);
        tempLayout.unsetValid(512).unsetValid(256);
        RenderedOp alpha = ConstantDescriptor.create((Float)Float.valueOf(image.getWidth()), (Float)Float.valueOf(image.getHeight()), (Number[])new Byte[]{(byte)-1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
        image = BandMergeDescriptor.create((RenderedImage)image, (RenderedImage)alpha, null);
        return image;
    }

    double mapToGrayColor(Color gray, ComponentColorModel cm) {
        double[] rescaleFactors = new double[33];
        rescaleFactors[0] = 1.0;
        rescaleFactors[2] = 255.0;
        rescaleFactors[3] = 8421504.0;
        rescaleFactors[1] = 512.0;
        rescaleFactors[5] = 0.00392156862745098;
        rescaleFactors[4] = 0.00392156862745098;
        rescaleFactors[32] = 1.0;
        return (double)gray.getRed() / rescaleFactors[cm.getTransferType()];
    }

    private static boolean isLevelOfGray(Color color) {
        return color.getRed() == color.getBlue() && color.getRed() == color.getGreen();
    }

    private static final RenderedImage createBkgImage(float width, float height, Color bgColor, RenderingHints renderingHints) {
        Number[] bands = new Byte[]{(byte)bgColor.getRed(), (byte)bgColor.getGreen(), (byte)bgColor.getBlue(), (byte)bgColor.getAlpha()};
        return ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])bands, (RenderingHints)renderingHints);
    }

    private static GridCoverage2D readBestCoverage(AbstractGridCoverage2DReader reader, Object params, ReferencedEnvelope requestedModelArea, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor) throws IOException {
        int length;
        Parameter bgColorParam;
        try {
            ReferencedEnvelope requestEnvelopeWGS84;
            ReferencedEnvelope dataEnvelopeWGS84;
            CoordinateReferenceSystem coverageCRS = reader.getCrs();
            CoordinateReferenceSystem requestCRS = requestedModelArea.getCoordinateReferenceSystem();
            ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope((org.opengis.geometry.Envelope)reader.getOriginalEnvelope());
            if (CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)requestCRS) ? !coverageEnvelope.intersects((BoundingBox)requestedModelArea) : !(dataEnvelopeWGS84 = coverageEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true)).intersects((BoundingBox)(requestEnvelopeWGS84 = requestedModelArea.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true)))) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to compare data and request envelopes, proceeding with rendering anyways", e);
        }
        Parameter readGG = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(requestedRasterArea), (org.opengis.geometry.Envelope)requestedModelArea));
        Parameter readInterpolation = (Parameter)ImageMosaicFormat.INTERPOLATION.createValue();
        readInterpolation.setValue((Object)interpolation);
        if (bgColor != null) {
            bgColorParam = (Parameter)AbstractGridFormat.BACKGROUND_COLOR.createValue();
            bgColorParam.setValue((Object)bgColor);
        } else {
            bgColorParam = null;
        }
        GridCoverage2D coverage = null;
        GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
        int n = length = readParams == null ? 0 : readParams.length;
        if (length > 0) {
            String readGGName = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            String readInterpolationName = ImageMosaicFormat.INTERPOLATION.getName().toString();
            String bgColorName = AbstractGridFormat.BACKGROUND_COLOR.getName().toString();
            boolean foundInterpolation = false;
            boolean foundGG = false;
            boolean foundBgColor = false;
            for (int i = 0; i < length; ++i) {
                String paramName = readParams[i].getDescriptor().getName().toString();
                if (paramName.equalsIgnoreCase(readGGName)) {
                    ((Parameter)readParams[i]).setValue((Object)readGG);
                    foundGG = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(readInterpolationName)) {
                    ((Parameter)readParams[i]).setValue((Object)interpolation);
                    foundInterpolation = true;
                    continue;
                }
                if (!paramName.equalsIgnoreCase(bgColorName) || bgColor == null) continue;
                ((Parameter)readParams[i]).setValue((Object)bgColor);
                foundBgColor = true;
            }
            if (!(foundGG && foundInterpolation && foundBgColor && bgColor != null)) {
                ArrayList<Object> paramList = new ArrayList<Object>();
                paramList.addAll(Arrays.asList(readParams));
                if (!foundGG) {
                    paramList.add(readGG);
                }
                if (!foundInterpolation) {
                    paramList.add(readInterpolation);
                }
                if (!foundBgColor && bgColor != null) {
                    paramList.add(bgColorParam);
                }
                readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
            }
            coverage = reader.read(readParams);
        } else {
            coverage = bgColorParam != null ? reader.read(new GeneralParameterValue[]{readGG, readInterpolation, bgColorParam}) : reader.read(new GeneralParameterValue[]{readGG, readInterpolation});
        }
        return coverage;
    }

    static List<RasterSymbolizer> getRasterSymbolizers(WMSMapContext mc, int layerIndex) {
        double scaleDenominator = RendererUtilities.calculateOGCScale((ReferencedEnvelope)mc.getAreaOfInterest(), (int)mc.getMapWidth(), null);
        MapLayer layer = mc.getLayer(layerIndex);
        FeatureType featureType = layer.getFeatureSource().getSchema();
        Style style = layer.getStyle();
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(scaleDenominator, featureType);
        style.accept((StyleVisitor)visitor);
        return visitor.getRasterSymbolizers();
    }
}

