/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.PlanarImage;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.legendgraphic.AbstractGetLegendGraphicResponse;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphic;
import org.geotools.image.ImageWorker;
import org.springframework.util.Assert;

public class PNGLegendGraphicResponse
extends AbstractGetLegendGraphicResponse {
    public PNGLegendGraphicResponse() {
        super(BufferedImageLegendGraphic.class, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object legend, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(BufferedImageLegendGraphic.class, (Object)legend);
        BufferedImage image = ((BufferedImageLegendGraphic)legend).getLegend();
        MemoryCacheImageOutputStream memOutStream = new MemoryCacheImageOutputStream(output);
        ImageWorker worker = new ImageWorker((RenderedImage)image);
        PlanarImage finalImage = image.getColorModel() instanceof DirectColorModel ? worker.forceComponentColorModel().getPlanarImage() : worker.getPlanarImage();
        Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType("image/png");
        ImageWriter writer = null;
        if (!it.hasNext()) {
            throw new IllegalStateException("No PNG ImageWriter found");
        }
        writer = it.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        if (writer.getClass().getName().equals("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter")) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(0.75f);
        }
        writer.setOutput(memOutStream);
        try {
            writer.write(null, new IIOImage((RenderedImage)finalImage, null, null), iwp);
            memOutStream.flush();
            memOutStream.close();
        }
        finally {
            writer.dispose();
        }
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        Assert.isInstanceOf(BufferedImageLegendGraphic.class, (Object)value);
        return "image/png";
    }
}

