/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.geoserver.wms.legendgraphic.SimpleColorManager;

class GradientColorManager
extends SimpleColorManager {
    private Color previousColor = null;
    private boolean leftEdge;

    public Dimension getPreferredDimension(Graphics2D graphics) {
        return new Dimension(this.requestedDimension.width, (int)(1.5 * (double)this.requestedDimension.height + 0.5));
    }

    public GradientColorManager(Color color, double opacity, Color previousColor, Dimension requestedDimension, Color borderColor) {
        super(color, opacity, requestedDimension, borderColor);
        this.previousColor = previousColor;
        if (previousColor == null) {
            this.leftEdge = true;
        }
    }

    public void draw(Graphics2D graphics, Rectangle2D clipBox, boolean completeBorder) {
        Rectangle2D.Double rectLegend;
        double minx = clipBox.getMinX();
        double miny = clipBox.getMinY();
        double w = clipBox.getWidth();
        double h = clipBox.getHeight();
        if (!this.leftEdge) {
            rectLegend = new Rectangle2D.Double(minx, miny, w, h / 2.0);
            Paint oldPaint = graphics.getPaint();
            GradientPaint paint = new GradientPaint((float)minx, (float)miny, this.previousColor, (float)minx, (float)(miny + h / 2.0), this.bkgColor);
            graphics.setPaint(paint);
            graphics.fill(rectLegend);
            graphics.setPaint(oldPaint);
        }
        rectLegend = new Rectangle2D.Double(minx, miny + (this.leftEdge ? 0.0 : h / 2.0), w, !this.leftEdge ? h / 2.0 : h);
        super.draw(graphics, rectLegend, completeBorder);
        if (completeBorder) {
            Color oldColor = graphics.getColor();
            graphics.setColor(this.borderColor);
            int minx_ = (int)(clipBox.getMinX() + 0.5);
            int maxx = (int)(minx + clipBox.getWidth() + 0.5) - 1;
            int maxy = (int)(miny + clipBox.getHeight() + 0.5) - 1;
            graphics.drawLine(minx_, maxy, maxx, maxy);
            graphics.setColor(oldColor);
        }
    }
}

