/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.FlatKvpParser;
import org.geoserver.ows.KvpParser;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapLayerInfoKvpParser
extends KvpParser {
    private FlatKvpParser rawNamesParser;
    private final WMS wms;

    public MapLayerInfoKvpParser(String key, WMS wms) {
        super(key, MapLayerInfo.class);
        this.wms = wms;
        this.rawNamesParser = new FlatKvpParser(key, String.class);
    }

    public List<MapLayerInfo> parse(String paramValue) throws Exception {
        List layerNames = (List)this.rawNamesParser.parse(paramValue);
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>(layerNames.size());
        MapLayerInfo layer = null;
        for (String layerName : layerNames) {
            LayerInfo layerInfo = this.wms.getLayerByName(layerName);
            if (layerInfo == null) {
                LayerGroupInfo groupInfo = this.wms.getLayerGroupByName(layerName);
                if (groupInfo == null) {
                    throw new ServiceException(layerName + ": no such layer on this server", "LayerNotDefined", ((Object)((Object)this)).getClass().getSimpleName());
                }
                for (LayerInfo li : groupInfo.getLayers()) {
                    layer = new MapLayerInfo(li);
                    layers.add(layer);
                }
                continue;
            }
            layer = new MapLayerInfo(layerInfo);
            layers.add(layer);
        }
        return layers;
    }
}

