/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.capabilities.GetCapabilitiesTransformer;

public class GetCapabilitiesResponse
extends Response {
    private WMS wms;

    public GetCapabilitiesResponse(WMS wms) {
        super(GetCapabilitiesTransformer.class);
        this.wms = wms;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (value instanceof GetCapabilitiesTransformer) {
            return "application/vnd.ogc.wms_xml";
        }
        throw new IllegalArgumentException(value == null ? "null" : value.getClass().getName() + "/" + operation.getId());
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Transformer dtdIncludeTransformer;
        GetCapabilitiesTransformer transformer = (GetCapabilitiesTransformer)((Object)value);
        GetCapabilitiesRequest request = (GetCapabilitiesRequest)operation.getParameters()[0];
        String internalDTDDeclaration = this.getInternalDTDDeclaration(request);
        if (internalDTDDeclaration == null) {
            try {
                transformer.transform(request, output);
            }
            catch (TransformerException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        try {
            transformer.transform(request, target);
        }
        catch (TransformerException e) {
            throw new ServiceException((Throwable)e);
        }
        byte[] rawCapabilities = target.toByteArray();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        String xsltSystemId = ((Object)((Object)this)).getClass().getResource("getcaps_111_internalDTD.xsl").toExternalForm();
        StreamSource tsource = new StreamSource(xsltSystemId);
        try {
            dtdIncludeTransformer = tFactory.newTransformer(tsource);
        }
        catch (TransformerConfigurationException e) {
            throw new ServiceException((Throwable)e);
        }
        dtdIncludeTransformer.setParameter("DTDDeclaration", internalDTDDeclaration.toString());
        StreamSource source = new StreamSource(new ByteArrayInputStream(rawCapabilities));
        StreamResult result = new StreamResult(output);
        try {
            dtdIncludeTransformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private String getInternalDTDDeclaration(GetCapabilitiesRequest request) {
        List<ExtendedCapabilitiesProvider> providers = this.wms.getAvailableExtendedCapabilitiesProviders();
        StringBuilder vendorSpecificCapsElements = new StringBuilder("<!ELEMENT VendorSpecificCapabilities (");
        StringBuilder internalDTDElements = new StringBuilder();
        int numRoots = 0;
        for (ExtendedCapabilitiesProvider provider : providers) {
            List<String> roots = provider.getVendorSpecificCapabilitiesRoots(request);
            if (roots == null || roots.size() <= 0) continue;
            for (String vendorRoot : roots) {
                if (++numRoots > 1) {
                    vendorSpecificCapsElements.append(", ");
                }
                vendorSpecificCapsElements.append(vendorRoot);
            }
            List<String> childDecls = provider.getVendorSpecificCapabilitiesChildDecls(request);
            for (String internalElement : childDecls) {
                internalDTDElements.append(internalElement);
                internalDTDElements.append('\n');
            }
        }
        vendorSpecificCapsElements.append(") >\n");
        String fullDTDDeclaration = null;
        if (numRoots > 0) {
            String baseURL = request.getBaseUrl();
            String dtdUrl = ResponseUtils.buildSchemaURL((String)baseURL, (String)"wms/1.1.1/WMS_MS_Capabilities.dtd");
            StringBuilder builder = new StringBuilder("<!DOCTYPE WMT_MS_Capabilities SYSTEM \"");
            builder.append(dtdUrl).append("\"[\n");
            builder.append((CharSequence)vendorSpecificCapsElements);
            builder.append((CharSequence)internalDTDElements);
            builder.append("]>\n");
            fullDTDDeclaration = builder.toString();
        }
        return fullDTDDeclaration;
    }
}

