/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ows.Layer;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.WMSMapLayer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFeatureInfo {
    private static final Logger LOGGER = Logging.getLogger(GetFeatureInfo.class);
    private WMS wms;

    public GetFeatureInfo(WMS wms) {
        this.wms = wms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureCollectionType run(GetFeatureInfoRequest request) throws ServiceException {
        List<FeatureCollection> results;
        EnvFunction.setLocalValues((Map)request.getGetMapRequest().getEnv());
        try {
            results = this.execute(request);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
        FeatureCollectionType ret = this.buildResults(results);
        return ret;
    }

    private FeatureCollectionType buildResults(List<FeatureCollection> results) {
        FeatureCollectionType result = WfsFactory.eINSTANCE.createFeatureCollectionType();
        result.setTimeStamp(Calendar.getInstance());
        result.getFeature().addAll(results);
        return result;
    }

    private List<FeatureCollection> execute(GetFeatureInfoRequest request) throws ServiceException {
        List<MapLayerInfo> layers = request.getQueryLayers();
        List filterList = request.getGetMapRequest().getFilter();
        Filter[] filters = filterList != null && filterList.size() > 0 ? filterList.toArray(new Filter[filterList.size()]) : new Filter[layers.size()];
        List<Style> getMapStyles = request.getGetMapRequest().getStyles();
        Style[] styles = new Style[layers.size()];
        block3: for (int i = 0; i < styles.length; ++i) {
            List<MapLayerInfo> getMapLayers = request.getGetMapRequest().getLayers();
            String targetLayer = layers.get(i).getName();
            for (int j = 0; j < getMapLayers.size(); ++j) {
                if (!getMapLayers.get(j).getName().equals(targetLayer)) continue;
                if (getMapStyles != null && getMapStyles.size() > 0) {
                    styles[i] = getMapStyles.get(j);
                }
                if (styles[i] != null) continue block3;
                styles[i] = getMapLayers.get(j).getDefaultStyle();
                continue block3;
            }
        }
        try {
            return this.execute(request, styles, filters);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Internal error occurred", (Throwable)e);
        }
    }

    private List<FeatureCollection> execute(GetFeatureInfoRequest request, Style[] styles, Filter[] filters) throws Exception {
        List<MapLayerInfo> requestedLayers = request.getQueryLayers();
        int x = request.getXPixel();
        int y = request.getYPixel();
        int buffer = request.getGetMapRequest().getBuffer();
        List<Map<String, String>> viewParams = request.getGetMapRequest().getViewParams();
        GetMapRequest getMapReq = request.getGetMapRequest();
        CoordinateReferenceSystem requestedCRS = getMapReq.getCrs();
        int width = getMapReq.getWidth();
        int height = getMapReq.getHeight();
        ReferencedEnvelope bbox = new ReferencedEnvelope(getMapReq.getBbox(), getMapReq.getCrs());
        double scaleDenominator = RendererUtilities.calculateOGCScale((ReferencedEnvelope)bbox, (int)width, null);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        ArrayList<FeatureCollection> results = new ArrayList<FeatureCollection>(requestedLayers.size());
        int maxFeatures = request.getFeatureCount();
        for (int i = 0; i < requestedLayers.size(); ++i) {
            int size;
            MapLayerInfo layer = requestedLayers.get(i);
            if (layer.getType() == MapLayerInfo.TYPE_WMS) {
                List<FeatureCollection> cascadedResults = this.handleGetFeatureInfoCascade(request, maxFeatures, layer);
                if (cascadedResults == null) continue;
                results.addAll(cascadedResults);
                continue;
            }
            Style style = styles[i];
            List<Rule> rules = this.getActiveRules(style, scaleDenominator);
            if (rules.size() == 0) continue;
            FeatureCollection collection = null;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                Map<String, String> viewParam = viewParams != null ? viewParams.get(i) : null;
                collection = this.identifyVectorLayer(filters, x, y, buffer, viewParam, requestedCRS, width, height, bbox, ff, results, i, layer, rules, maxFeatures);
            } else if (layer.getType() == MapLayerInfo.TYPE_RASTER) {
                CoverageInfo cinfo = requestedLayers.get(i).getCoverage();
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)cinfo.getGridCoverageReader((ProgressListener)new NullProgressListener(), GeoTools.getDefaultHints());
                GridGeometry2D coverageGeometry = (GridGeometry2D)cinfo.getGrid();
                Coordinate middle = this.pixelToWorld(x, y, bbox, width, height);
                DirectPosition2D position = new DirectPosition2D(requestedCRS, middle.x, middle.y);
                if (requestedCRS != null) {
                    CoordinateReferenceSystem targetCRS = coverageGeometry.getCoordinateReferenceSystem();
                    TransformedDirectPosition arbitraryToInternal = new TransformedDirectPosition(requestedCRS, targetCRS, new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
                    try {
                        arbitraryToInternal.transform((DirectPosition)position);
                    }
                    catch (TransformException exception) {
                        throw new CannotEvaluateException("Unable to answer the geatfeatureinfo", (Throwable)exception);
                    }
                    position = arbitraryToInternal;
                }
                if (!reader.getOriginalEnvelope().contains((DirectPosition)position)) continue;
                GeneralParameterValue[] parameters = this.wms.getWMSReadParameters(request.getGetMapRequest(), requestedLayers.get(i), filters[i], reader, true);
                collection = this.identifyRasterLayer(reader, (DirectPosition)position, parameters, cinfo, getMapReq);
            } else {
                LOGGER.log(Level.SEVERE, "Can't perform feature info requests on " + layer.getName() + ", layer type not supported");
            }
            if (collection == null || (size = collection.size()) == 0) continue;
            results.add(collection);
            if ((maxFeatures -= size) <= 0) break;
        }
        return results;
    }

    private FeatureCollection identifyRasterLayer(AbstractGridCoverage2DReader reader, DirectPosition position, GeneralParameterValue[] parameters, CoverageInfo cinfo, GetMapRequest getMapReq) throws Exception {
        GridCoverage2D coverage;
        double elevationValue;
        boolean hasElevation;
        MathTransform worldToGrid = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
        DirectPosition rasterMid = worldToGrid.transform(position, null);
        Rectangle2D.Double rasterArea = new Rectangle2D.Double();
        rasterArea.setFrameFromCenter(rasterMid.getOrdinate(0), rasterMid.getOrdinate(1), rasterMid.getOrdinate(0) + 10.0, rasterMid.getOrdinate(1) + 10.0);
        Rectangle integerRasterArea = rasterArea.getBounds();
        GridEnvelope gridEnvelope = reader.getOriginalGridRange();
        Object originalArea = gridEnvelope instanceof GridEnvelope2D ? (GridEnvelope2D)gridEnvelope : new Rectangle();
        XRectangle2D.intersect((Rectangle2D)integerRasterArea, (Rectangle2D)originalArea, (Rectangle2D)integerRasterArea);
        if (integerRasterArea.isEmpty()) {
            return null;
        }
        for (int k = 0; k < parameters.length; ++k) {
            Parameter parameter;
            if (!(parameters[k] instanceof Parameter) || !(parameter = (Parameter)parameters[k]).getDescriptor().getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
            parameter.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(integerRasterArea), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCrs()));
        }
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        List<Date> dateTime = getMapReq.getTime();
        boolean hasTime = dateTime != null && dateTime.size() > 0;
        List parameterDescriptors = readParametersDescriptor.getDescriptor().descriptors();
        if (hasTime) {
            for (GeneralParameterDescriptor pd : parameterDescriptors) {
                if (!pd.getName().getCode().equalsIgnoreCase("TIME")) continue;
                ParameterValue time = (ParameterValue)pd.createValue();
                if (time != null) {
                    time.setValue(getMapReq.getTime());
                }
                GeneralParameterValue[] readParametersClone = new GeneralParameterValue[parameters.length + 1];
                System.arraycopy(parameters, 0, readParametersClone, 0, parameters.length);
                readParametersClone[parameters.length] = time;
                parameters = readParametersClone;
                break;
            }
        }
        boolean bl = hasElevation = !Double.isNaN(elevationValue = getMapReq.getElevation());
        if (hasElevation) {
            for (GeneralParameterDescriptor pd : parameterDescriptors) {
                if (!pd.getName().getCode().equalsIgnoreCase("ELEVATION")) continue;
                ParameterValue elevation = (ParameterValue)pd.createValue();
                if (elevation != null) {
                    elevation.setValue(getMapReq.getElevation());
                }
                GeneralParameterValue[] readParametersClone = new GeneralParameterValue[parameters.length + 1];
                System.arraycopy(parameters, 0, readParametersClone, 0, parameters.length);
                readParametersClone[parameters.length] = elevation;
                parameters = readParametersClone;
                break;
            }
        }
        if ((coverage = reader.read(parameters)) == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to load raster data for this request.");
            }
            return null;
        }
        SimpleFeatureCollection pixel = null;
        try {
            double[] pixelValues = coverage.evaluate(position, (double[])null);
            pixel = this.wrapPixelInFeatureCollection(coverage, pixelValues, cinfo.getQualifiedName());
        }
        catch (PointOutsideCoverageException e) {
            // empty catch block
        }
        return pixel;
    }

    private FeatureCollection identifyVectorLayer(Filter[] filters, int x, int y, int buffer, Map<String, String> viewParams, CoordinateReferenceSystem requestedCRS, int width, int height, ReferencedEnvelope bbox, FilterFactory2 ff, List<FeatureCollection> results, int i, MapLayerInfo layer, List<Rule> rules, int maxFeatures) throws IOException {
        double radius;
        CoordinateReferenceSystem dataCRS = layer.getCoordinateReferenceSystem();
        if (buffer <= 0) {
            Integer layerBuffer = null;
            LayerInfo layerInfo = layer.getLayerInfo();
            if (layerInfo != null) {
                layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class);
            }
            if (layerBuffer != null && layerBuffer > 0) {
                radius = (double)layerBuffer.intValue() / 2.0;
            } else {
                MetaBufferEstimator estimator = new MetaBufferEstimator();
                for (Rule rule : rules) {
                    rule.accept((StyleVisitor)estimator);
                }
                radius = (double)estimator.getBuffer() < 6.0 || !estimator.isEstimateAccurate() ? 3.0 : (double)estimator.getBuffer() / 2.0;
            }
        } else {
            radius = buffer;
        }
        int maxRadius = this.wms.getMaxBuffer();
        if (maxRadius > 0 && radius > (double)maxRadius) {
            radius = maxRadius;
        }
        Polygon pixelRect = this.getEnvelopeFilter(x, y, width, height, bbox, radius);
        if (requestedCRS != null && !CRS.equalsIgnoreMetadata((Object)dataCRS, (Object)requestedCRS)) {
            try {
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)requestedCRS, (CoordinateReferenceSystem)dataCRS, (boolean)true);
                pixelRect = (Polygon)JTS.transform((Geometry)pixelRect, (MathTransform)transform);
            }
            catch (MismatchedDimensionException e) {
                LOGGER.severe(e.getLocalizedMessage());
            }
            catch (TransformException e) {
                LOGGER.severe(e.getLocalizedMessage());
            }
            catch (FactoryException e) {
                LOGGER.severe(e.getLocalizedMessage());
            }
        }
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = layer.getFeatureSource(false);
        FeatureType schema = featureSource.getSchema();
        Intersects getFInfoFilter = null;
        try {
            GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
            String localName = geometryDescriptor.getLocalName();
            getFInfoFilter = ff.intersects((Expression)ff.property(localName), (Expression)ff.literal((Object)pixelRect));
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            throw new ServiceException("Internal error : " + e.getMessage(), (Throwable)e);
        }
        if (filters[i] != null) {
            getFInfoFilter = ff.and((Filter)getFInfoFilter, filters[i]);
        }
        IncludeFilter postFilter = Filter.INCLUDE;
        Filter rulesFilters = this.buildRulesFilter((FilterFactory)ff, rules);
        if (!(rulesFilters instanceof Or) || rulesFilters instanceof Or && ((Or)rulesFilters).getChildren().size() <= 20) {
            getFInfoFilter = ff.and((Filter)getFInfoFilter, rulesFilters);
        } else {
            postFilter = rulesFilters;
        }
        String typeName = schema.getName().getLocalPart();
        Query q = new Query(typeName, null, (Filter)getFInfoFilter, maxFeatures, Query.ALL_NAMES, null);
        if (viewParams != null && viewParams.size() > 0) {
            q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams));
        }
        FeatureCollection match = featureSource.getFeatures(q);
        if (!Filter.INCLUDE.equals(postFilter)) {
            match = DataUtilities.simple((FeatureCollection)new FilteringFeatureCollection(match, (Filter)postFilter));
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FeatureCollection> handleGetFeatureInfoCascade(GetFeatureInfoRequest request, int maxFeatures, MapLayerInfo layerInfo) throws Exception {
        int x = request.getXPixel();
        int y = request.getYPixel();
        WMSLayerInfo info = (WMSLayerInfo)layerInfo.getResource();
        WebMapServer wms = info.getStore().getWebMapServer(null);
        Layer layer = info.getWMSLayer(null);
        CoordinateReferenceSystem crs = request.getGetMapRequest().getCrs();
        if (crs == null) {
            crs = info.getCRS();
        }
        ReferencedEnvelope bbox = new ReferencedEnvelope(request.getGetMapRequest().getBbox(), crs);
        int width = request.getGetMapRequest().getWidth();
        int height = request.getGetMapRequest().getHeight();
        if (!layer.isQueryable()) {
            return null;
        }
        List infoFormats = wms.getCapabilities().getRequest().getGetFeatureInfo().getFormats();
        if (!infoFormats.contains("application/vnd.ogc.gml")) {
            return null;
        }
        WMSMapLayer ml = new WMSMapLayer(wms, layer);
        InputStream is = ml.getFeatureInfo(bbox, width, height, x, y, "application/vnd.ogc.gml", maxFeatures);
        Object results = null;
        try {
            Parser parser = new Parser((Configuration)new WFSConfiguration());
            parser.setStrict(false);
            Object result = parser.parse(is);
            if (result instanceof FeatureCollectionType) {
                FeatureCollectionType fcList = (FeatureCollectionType)result;
                results = fcList.getFeature();
                ArrayList<ReTypingFeatureCollection> retypedResults = new ArrayList<ReTypingFeatureCollection>(results.size());
                for (SimpleFeatureCollection fc : results) {
                    SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
                    SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                    builder.init(ft);
                    builder.setName(info.getName());
                    builder.setNamespaceURI(info.getNamespace().getURI());
                    ReTypingFeatureCollection rfc = new ReTypingFeatureCollection(fc, builder.buildFeatureType());
                    retypedResults.add(rfc);
                }
                results = retypedResults;
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Tried to parse GML2 response, but failed", t);
        }
        finally {
            is.close();
        }
        return results;
    }

    private Filter buildRulesFilter(FilterFactory ff, List<Rule> rules) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Rule rule : rules) {
            if (rule.getFilter() == null || rule.isElseFilter()) {
                return Filter.INCLUDE;
            }
            filters.add(rule.getFilter());
        }
        Or or = ff.or(filters);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        return (Filter)or.accept((FilterVisitor)simplifier, null);
    }

    private List<Rule> getActiveRules(Style style, double scaleDenominator) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (FeatureTypeStyle fts : style.getFeatureTypeStyles()) {
            for (Rule r : fts.rules()) {
                if (!(r.getMinScaleDenominator() <= scaleDenominator) || !(r.getMaxScaleDenominator() > scaleDenominator)) continue;
                result.add(r);
            }
        }
        return result;
    }

    private Polygon getEnvelopeFilter(int x, int y, int width, int height, ReferencedEnvelope bbox, double radius) {
        Coordinate[] coords;
        Coordinate upperLeft = this.pixelToWorld((double)x - radius, (double)y - radius, bbox, width, height);
        Coordinate lowerRight = this.pixelToWorld((double)x + radius, (double)y + radius, bbox, width, height);
        coords = new Coordinate[]{upperLeft, new Coordinate(lowerRight.x, upperLeft.y), lowerRight, new Coordinate(upperLeft.x, lowerRight.y), coords[0]};
        GeometryFactory geomFac = new GeometryFactory();
        LinearRing boundary = geomFac.createLinearRing(coords);
        Polygon pixelRect = geomFac.createPolygon(boundary, null);
        return pixelRect;
    }

    private SimpleFeatureCollection wrapPixelInFeatureCollection(GridCoverage2D coverage, double[] pixelValues, Name coverageName) throws SchemaException {
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(coverageName);
        HashSet<String> bandNames = new HashSet<String>();
        for (int i = 0; i < sampleDimensions.length; ++i) {
            String name = sampleDimensions[i].getDescription().toString();
            if (bandNames.contains(name)) {
                name = name + "_Band" + i;
            }
            bandNames.add(name);
            builder.add(name, Double.class);
        }
        SimpleFeatureType gridType = builder.buildFeatureType();
        Object[] values = new Double[pixelValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Double(pixelValues[i]);
        }
        return DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.build((SimpleFeatureType)gridType, (Object[])values, (String)""));
    }

    private Coordinate pixelToWorld(double x, double y, ReferencedEnvelope map, double width, double height) {
        AffineTransform at = this.worldToScreenTransform(map, width, height);
        Point2D result = null;
        try {
            result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Coordinate c = new Coordinate(result.getX(), result.getY());
        return c;
    }

    private AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, double width, double height) {
        boolean swap;
        CoordinateReferenceSystem crs = mapExtent.getCoordinateReferenceSystem();
        boolean bl = swap = crs != null && CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST;
        if (swap) {
            mapExtent = new ReferencedEnvelope(mapExtent.getMinY(), mapExtent.getMaxY(), mapExtent.getMinX(), mapExtent.getMaxX(), null);
        }
        double scaleX = width / mapExtent.getWidth();
        double scaleY = height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        if (swap) {
            at.concatenate(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        }
        return at;
    }
}

