/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import org.geoserver.kml.KMLTransformerBase;
import org.geoserver.kml.KMLUtils;
import org.geoserver.wms.WMSMapContext;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;

public class KMLLegendTransformer
extends KMLTransformerBase {
    WMSMapContext mapContext;

    public KMLLegendTransformer(WMSMapContext mapContext) {
        this.mapContext = mapContext;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLLegendTranslator(handler);
    }

    class KMLLegendTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        public KMLLegendTranslator(ContentHandler contentHandler) {
            super(KMLLegendTransformer.this, contentHandler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            MapLayer mapLayer = (MapLayer)o;
            if (KMLLegendTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("ScreenOverlay");
            this.element("name", "Legend");
            this.element("overlayXY", null, KMLUtils.attributes(new String[]{"x", "0", "y", "0", "xunits", "pixels", "yunits", "pixels"}));
            this.element("screenXY", null, KMLUtils.attributes(new String[]{"x", "10", "y", "20", "xunits", "pixels", "yunits", "pixels"}));
            this.start("Icon");
            String legendOptions = KMLLegendTransformer.this.mapContext.getRequest().getRawKvp().get("LEGEND_OPTIONS");
            String[] kvpArray = null;
            if (legendOptions != null) {
                kvpArray = new String[]{"LEGEND_OPTIONS", legendOptions};
            }
            this.element("href", KMLUtils.getLegendGraphicUrl(KMLLegendTransformer.this.mapContext, mapLayer, kvpArray));
            this.end("Icon");
            this.end("ScreenOverlay");
            if (KMLLegendTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }
    }
}

