/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingGridFormat;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;

public class SecuredGridFormat
extends DecoratingGridFormat {
    WrapperPolicy policy;

    public SecuredGridFormat(AbstractGridFormat delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        AbstractGridCoverage2DReader reader = this.delegate.getReader(source, hints);
        if (reader == null) {
            return reader;
        }
        return (AbstractGridCoverage2DReader)SecuredObjects.secure(reader, this.policy);
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        AbstractGridCoverage2DReader reader = this.delegate.getReader(source);
        if (reader == null) {
            return reader;
        }
        return (AbstractGridCoverage2DReader)SecuredObjects.secure(reader, this.policy);
    }

    RuntimeException notifyUnsupportedOperation() {
        if (this.policy.response == Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess();
        }
        return new UnsupportedOperationException("This data access is read only, service code is supposed to perform writes via FeatureStore instead");
    }
}

