/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.security.Response;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.CheckAttributesFeatureCollection;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecurityUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredFeatureStore<T extends FeatureType, F extends Feature>
extends SecuredFeatureSource<T, F>
implements FeatureStore<T, F> {
    Transaction transaction;
    FeatureStore<T, F> storeDelegate;

    public SecuredFeatureStore(FeatureStore delegate, WrapperPolicy policy) {
        super(delegate, policy);
        this.storeDelegate = delegate;
    }

    public List<FeatureId> addFeatures(FeatureCollection<T, F> collection) throws IOException {
        FilteringFeatureCollection filtered;
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery.getFilter() == Filter.EXCLUDE || writeQuery.getPropertyNames() == Query.NO_NAMES) {
            throw this.unsupportedOperation();
        }
        if (writeQuery == Query.ALL) {
            return this.storeDelegate.addFeatures(collection);
        }
        if (writeQuery.getFilter() != null && writeQuery.getFilter() != Filter.INCLUDE && (filtered = new FilteringFeatureCollection(collection, writeQuery.getFilter())).size() < collection.size()) {
            String typeName = this.getSchema().getName().getLocalPart();
            if (this.policy.response == Response.CHALLENGE) {
                throw SecureCatalogImpl.unauthorizedAccess(typeName);
            }
            throw new UnsupportedOperationException("At least one of the features inserted does not satisfy your write restrictions");
        }
        if (writeQuery.getPropertyNames() == Query.ALL_NAMES) {
            return this.storeDelegate.addFeatures(collection);
        }
        if (collection.getSchema() instanceof SimpleFeatureType && this.storeDelegate instanceof SimpleFeatureStore) {
            SimpleFeatureCollection simpleCollection = (SimpleFeatureCollection)collection;
            List<String> writableAttributes = Arrays.asList(writeQuery.getPropertyNames());
            CheckAttributesFeatureCollection checker = new CheckAttributesFeatureCollection(simpleCollection, writableAttributes, this.policy.getResponse());
            return ((SimpleFeatureStore)this.storeDelegate).addFeatures((FeatureCollection)checker);
        }
        LOGGER.log(Level.SEVERE, "Unfinished implementation, we need to shave off the attributes one cannot write off complex features. However at this time there is no writable complex feature!");
        return this.storeDelegate.addFeatures(collection);
    }

    public void modifyFeatures(AttributeDescriptor[] types, Object[] values, Filter filter) throws IOException {
        Name[] names = new Name[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getName();
        }
        this.modifyFeatures(names, values, filter);
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeDescriptor[]{type}, new Object[]{value}, filter);
    }

    public void modifyFeatures(Name[] names, Object[] values, Filter filter) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery == Query.ALL) {
            this.storeDelegate.modifyFeatures(names, values, filter);
        } else if (writeQuery.getFilter() == Filter.EXCLUDE || writeQuery.getPropertyNames() == Query.NO_NAMES) {
            throw this.unsupportedOperation();
        }
        Query local = new Query(null, filter);
        Query mixed = DataUtilities.mixQueries((Query)local, (Query)writeQuery, null);
        if (writeQuery.getPropertyNames() == Query.ALL_NAMES) {
            this.storeDelegate.modifyFeatures(names, values, mixed.getFilter());
        } else {
            HashSet<String> queryNames = new HashSet<String>(Arrays.asList(writeQuery.getPropertyNames()));
            for (int i = 0; i < names.length; ++i) {
                String localName = names[i].getLocalPart();
                if (!queryNames.contains(localName)) continue;
                String typeName = this.getSchema().getName().getLocalPart();
                if (this.policy.getResponse() == Response.CHALLENGE) {
                    throw SecureCatalogImpl.unauthorizedAccess(typeName);
                }
                throw new UnsupportedOperationException("Trying to write on the write protected attribute " + names[i]);
            }
            this.storeDelegate.modifyFeatures(names, values, mixed.getFilter());
        }
    }

    public void modifyFeatures(Name attributeName, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{attributeName}, new Object[]{attributeValue}, filter);
    }

    public void removeFeatures(Filter filter) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery == Query.ALL) {
            this.storeDelegate.removeFeatures(filter);
        } else if (writeQuery.getFilter() == Filter.EXCLUDE || writeQuery.getPropertyNames() == Query.NO_NAMES) {
            throw this.unsupportedOperation();
        }
        Query local = new Query(null, filter);
        Query mixed = DataUtilities.mixQueries((Query)local, (Query)writeQuery, null);
        this.storeDelegate.removeFeatures(mixed.getFilter());
    }

    public void setFeatures(FeatureReader<T, F> reader) throws IOException {
        throw new UnsupportedOperationException("Unaware of any GS api using this, so it has not been implemented");
    }

    public Transaction getTransaction() {
        return this.storeDelegate.getTransaction();
    }

    public void setTransaction(Transaction transaction) {
        this.storeDelegate.setTransaction(transaction);
    }

    protected RuntimeException unsupportedOperation() {
        String typeName = this.getSchema().getName().getLocalPart();
        if (this.policy.response == Response.CHALLENGE) {
            return SecureCatalogImpl.unauthorizedAccess(typeName);
        }
        return new UnsupportedOperationException(typeName + " is read only");
    }
}

