/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.platform.GeoServerExtensions;

public class SpringDelegatingFilter
implements Filter {
    List<GeoServerFilter> filters;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filters = GeoServerExtensions.extensions(GeoServerFilter.class);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        new Chain(chain).doFilter(request, response);
    }

    public void destroy() {
        if (this.filters != null) {
            for (GeoServerFilter f : this.filters) {
                f.destroy();
            }
            this.filters = null;
        }
    }

    class Chain
    implements FilterChain {
        FilterChain delegate;
        int filter = 0;

        public Chain(FilterChain chain) {
            this.delegate = chain;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.filter < SpringDelegatingFilter.this.filters.size()) {
                SpringDelegatingFilter.this.filters.get(this.filter++).doFilter(request, response, this);
            } else {
                this.delegate.doFilter(request, response);
            }
        }
    }
}

