/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geoserver.feature.DecoratingFeatureCollection;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetypingFeatureCollection
extends DecoratingFeatureCollection {
    SimpleFeatureType target;

    public RetypingFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType target) {
        super(delegate);
        this.target = target;
    }

    public SimpleFeatureType getSchema() {
        return this.target;
    }

    public Iterator<SimpleFeature> iterator() {
        return new RetypingIterator(this.delegate.iterator(), this.target);
    }

    public void close(Iterator<SimpleFeature> iterator) {
        RetypingIterator retyping = (RetypingIterator)iterator;
        this.delegate.close(retyping.delegate);
    }

    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator((FeatureCollection)this, this.iterator());
    }

    public void close(SimpleFeatureIterator iterator) {
        DelegateSimpleFeatureIterator delegate = (DelegateSimpleFeatureIterator)iterator;
        delegate.close();
    }

    static SimpleFeature retype(SimpleFeature source, SimpleFeatureBuilder builder) throws IllegalAttributeException {
        SimpleFeatureType target = builder.getFeatureType();
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = target.getDescriptor(i);
            Object value = null;
            if (source.getFeatureType().getDescriptor(attributeType.getName()) != null) {
                value = source.getAttribute(attributeType.getName());
            }
            builder.add(value);
        }
        FeatureId id = RetypingFeatureCollection.reTypeId(source.getIdentifier(), source.getFeatureType(), target);
        return builder.buildFeature(id.getID());
    }

    public static FeatureId reTypeId(FeatureId sourceId, SimpleFeatureType original, SimpleFeatureType target) {
        String originalTypeName = original.getName().getLocalPart();
        String destTypeName = target.getName().getLocalPart();
        if (destTypeName.equals(originalTypeName)) {
            return sourceId;
        }
        String prefix = originalTypeName + ".";
        if (sourceId.getID().startsWith(prefix)) {
            return new FeatureIdImpl(destTypeName + "." + sourceId.getID().substring(prefix.length()));
        }
        return sourceId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetypingFeatureWriter
    implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
        FeatureWriter<SimpleFeatureType, SimpleFeature> delegate;
        SimpleFeatureBuilder builder;
        private SimpleFeature current;
        private SimpleFeature retyped;

        public RetypingFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(target);
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate = null;
            this.builder = null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.builder.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws IOException {
            try {
                this.current = (SimpleFeature)this.delegate.next();
                this.retyped = RetypingFeatureCollection.retype(this.current, this.builder);
                return this.retyped;
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Error occurred while retyping feature").initCause(e);
            }
        }

        public void remove() throws IOException {
            this.delegate.write();
        }

        public void write() throws IOException {
            try {
                SimpleFeatureType target = this.getFeatureType();
                for (int i = 0; i < target.getAttributeCount(); ++i) {
                    AttributeDescriptor at = target.getDescriptor(i);
                    Object value = this.retyped.getAttribute(i);
                    this.current.setAttribute(at.getLocalName(), value);
                }
                this.delegate.write();
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Error occurred while retyping feature").initCause(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetypingFeatureReader
    implements FeatureReader<SimpleFeatureType, SimpleFeature> {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;
        SimpleFeatureBuilder builder;

        public RetypingFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(target);
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate = null;
            this.builder = null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.builder.getFeatureType();
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
            return RetypingFeatureCollection.retype((SimpleFeature)this.delegate.next(), this.builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetypingIterator
    implements Iterator<SimpleFeature> {
        SimpleFeatureBuilder builder;
        Iterator<SimpleFeature> delegate;

        public RetypingIterator(Iterator<SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.builder = new SimpleFeatureBuilder(target);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() {
            try {
                return RetypingFeatureCollection.retype(this.delegate.next(), this.builder);
            }
            catch (IllegalAttributeException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

