/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.sld.v1_1.SLDConfiguration;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.InputSource;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Styles {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms");
    static int XML_LOOKAHEAD = 8192;
    static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public static StyledLayerDescriptor parse(Object input) throws IOException {
        Object[] obj = Styles.findVersion(input);
        return Styles.parse(obj[1], (Version)obj[0]);
    }

    public static StyledLayerDescriptor parse(Object input, Version version) throws IOException {
        return Handler.lookup(version).parse(input);
    }

    public static void encode(StyledLayerDescriptor sld, Version version, boolean format, OutputStream output) throws IOException {
        Handler.lookup(version).encode(sld, format, output);
    }

    public static List<Exception> validate(Object input) throws IOException {
        Object[] obj = Styles.findVersion(input);
        return Styles.validate(obj[1], (Version)obj[0]);
    }

    public static List<Exception> validate(Object input, Version version) throws IOException {
        return Handler.lookup(version).validate(input);
    }

    public static Style style(StyledLayerDescriptor sld) {
        for (int i = 0; i < sld.getStyledLayers().length; ++i) {
            Style[] styles = null;
            if (sld.getStyledLayers()[i] instanceof NamedLayer) {
                NamedLayer layer = (NamedLayer)sld.getStyledLayers()[i];
                styles = layer.getStyles();
            } else if (sld.getStyledLayers()[i] instanceof UserLayer) {
                UserLayer layer = (UserLayer)sld.getStyledLayers()[i];
                styles = layer.getUserStyles();
            }
            if (styles == null) continue;
            int j = 0;
            while (j < styles.length) {
                if (!(styles[j] instanceof NamedStyle)) {
                    return styles[j];
                }
                ++i;
            }
        }
        return null;
    }

    public static StyledLayerDescriptor sld(Style style) {
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        NamedLayer layer = styleFactory.createNamedLayer();
        layer.setName(style.getName());
        sld.addStyledLayer((StyledLayer)layer);
        layer.addStyle(style);
        return sld;
    }

    static Object[] findVersion(Object input) throws IOException {
        String version;
        BufferedReader reader = null;
        reader = input instanceof InputStream ? RequestUtils.getBufferedXMLReader((InputStream)((InputStream)input), (int)8192) : RequestUtils.getBufferedXMLReader((Reader)Styles.toReader(input), (int)8192);
        if (!reader.ready()) {
            return null;
        }
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)reader);
            parser.nextTag();
            version = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (!"version".equals(parser.getAttributeName(i))) continue;
                version = parser.getAttributeValue(i);
            }
            parser.setInput(null);
        }
        catch (XmlPullParserException e) {
            throw (IOException)new IOException("Error parsing content").initCause(e);
        }
        reader.reset();
        if (version == null) {
            LOGGER.warning("Could not determine SLD version from content. Assuming 1.0.0");
            version = "1.0.0";
        }
        return new Object[]{new Version(version), reader};
    }

    static Reader toReader(Object input) throws IOException {
        if (input instanceof Reader) {
            return (Reader)input;
        }
        if (input instanceof InputStream) {
            return new InputStreamReader((InputStream)input);
        }
        if (input instanceof File) {
            return new FileReader((File)input);
        }
        throw new IllegalArgumentException("Unable to turn " + input + " into reader");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Handler {
        SLD_10("1.0.0"){

            @Override
            public StyledLayerDescriptor parse(Object input) throws IOException {
                Style[] style;
                SLDParser p = this.parser(input);
                StyledLayerDescriptor sld = p.parseSLD();
                if (sld.getStyledLayers().length == 0 && (style = p.readDOM()).length > 0) {
                    NamedLayer l = styleFactory.createNamedLayer();
                    l.addStyle(style[0]);
                    sld.addStyledLayer((StyledLayer)l);
                }
                return sld;
            }

            @Override
            protected List<Exception> validate(Object input) throws IOException {
                return new SLDValidator().validateSLD(new InputSource(Styles.toReader(input)), null);
            }

            @Override
            public void encode(StyledLayerDescriptor sld, boolean format, OutputStream output) throws IOException {
                SLDTransformer tx = new SLDTransformer();
                if (format) {
                    tx.setIndentation(2);
                }
                try {
                    tx.transform((Object)sld, output);
                }
                catch (TransformerException e) {
                    throw (IOException)new IOException("Error writing style").initCause(e);
                }
            }

            SLDParser parser(Object input) throws IOException {
                if (input instanceof File) {
                    return new SLDParser(styleFactory, (File)input);
                }
                return new SLDParser(styleFactory, Styles.toReader(input));
            }
        }
        ,
        SLD_11("1.1.0"){

            @Override
            public StyledLayerDescriptor parse(Object input) throws IOException {
                SLDConfiguration sld = new SLDConfiguration();
                try {
                    return (StyledLayerDescriptor)new Parser((Configuration)sld).parse(Styles.toReader(input));
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw (IOException)new IOException().initCause(e);
                }
            }

            @Override
            protected List<Exception> validate(Object input) throws IOException {
                SLDConfiguration sld = new SLDConfiguration();
                Parser p = new Parser((Configuration)sld);
                p.setValidating(true);
                try {
                    p.parse(Styles.toReader(input));
                    return p.getValidationErrors();
                }
                catch (Exception e) {
                    return Collections.singletonList(e);
                }
            }

            @Override
            public void encode(StyledLayerDescriptor sld, boolean format, OutputStream output) throws IOException {
            }
        };

        private Version version;

        private Handler(String version) {
            this.version = new Version(version);
        }

        public Version getVersion() {
            return this.version;
        }

        protected abstract StyledLayerDescriptor parse(Object var1) throws IOException;

        protected abstract void encode(StyledLayerDescriptor var1, boolean var2, OutputStream var3) throws IOException;

        protected abstract List<Exception> validate(Object var1) throws IOException;

        public static Handler lookup(Version version) {
            for (Handler h : Handler.values()) {
                if (!h.getVersion().equals((Object)version)) continue;
                return h;
            }
            throw new IllegalArgumentException("No support for SLD " + version);
        }
    }
}

