/*
 * Decompiled with CFR 0.152.
 */
package simple.util.parse;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import simple.util.net.Cookie;
import simple.util.net.CookieCollection;
import simple.util.parse.Parser;

public class CookieParser
extends Parser
implements CookieCollection {
    private transient boolean finished = true;
    private transient boolean parsed;
    private transient int version;
    private Token name;
    private Token value;
    private Token path = new Token();
    private Token domain = new Token();

    public CookieParser() {
        this.name = new Token();
        this.value = new Token();
    }

    public CookieParser(String header) {
        this();
        this.parse(header);
    }

    protected void init() {
        this.finished = false;
        this.parsed = false;
        this.version = 0;
        this.off = 0;
        this.version();
    }

    protected void parse() {
        if (!this.finished) {
            this.cookie();
            this.parsed = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean skip(String text) {
        size = text.length();
        seek = this.off;
        read = 0;
        if (this.off + size <= this.count) ** GOTO lbl18
        return false;
lbl-1000:
        // 1 sources

        {
            a = text.charAt(read);
            b = this.buf[seek];
            if (this.space(b)) {
                if (++seek < this.count) continue;
                return false;
            }
            if (this.space(a)) {
                if (++read < size) continue;
                continue;
            }
            if (this.toLower(a) != this.toLower(b)) {
                return false;
            }
            ++read;
            ++seek;
lbl18:
            // 5 sources

            ** while (read < size)
        }
lbl19:
        // 1 sources

        this.off = seek;
        while (this.off < this.count) {
            if (!this.space(this.buf[this.off])) break;
            ++this.off;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(new String(this.buf, 0, this.count));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parse((String)in.readObject());
    }

    public void reset() {
        this.init();
        this.parse();
    }

    public Cookie next() {
        if (!this.hasMore()) {
            return null;
        }
        this.parsed = false;
        return this.getCookie();
    }

    private Cookie getCookie() {
        return this.getCookie(this.name.toString(), this.value.toString());
    }

    private Cookie getCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        if (this.domain.len > 0) {
            cookie.setDomain(this.domain.toString());
        }
        if (this.path.len > 0) {
            cookie.setPath(this.path.toString());
        }
        cookie.setVersion(this.version);
        return cookie;
    }

    public boolean hasMore() {
        if (this.finished) {
            return false;
        }
        if (this.parsed) {
            return true;
        }
        this.parse();
        if (this.name.len <= 0) {
            this.finished = true;
            return false;
        }
        return true;
    }

    private void cookie() {
        if (!this.skip(",")) {
            this.skip(";");
        }
        this.name();
        this.skip("=");
        this.value();
    }

    private void name() {
        this.name.off = this.off;
        this.name.len = 0;
        while (this.off < this.count) {
            if (this.buf[this.off] == '=') break;
            ++this.name.len;
            ++this.off;
        }
    }

    private void value() {
        this.data();
        this.path();
        this.domain();
    }

    /*
     * Unable to fully structure code
     */
    private void data() {
        block2: {
            this.value.off = this.off;
            this.value.len = 0;
            if (this.off >= this.count || this.buf[this.off] != '\"') ** GOTO lbl16
            ++this.value.len;
            ++this.off;
            while (this.off < this.count) {
                ++this.value.len;
                if (this.buf[this.off++] == '\"' && this.buf[this.off - 2] != '\\') break;
            }
            this.value.len -= 2;
            ++this.value.off;
            break block2;
            while (!this.terminal(this.buf[this.off])) {
                ++this.value.len;
                ++this.off;
lbl16:
                // 2 sources

                if (this.off < this.count) continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void path() {
        block2: {
            this.path.len = 0;
            if (!this.skip(";$Path=")) break block2;
            this.path.off = this.off;
            if (this.buf[this.off] != '\"') ** GOTO lbl17
            ++this.path.len;
            ++this.off;
            while (this.off < this.count) {
                ++this.path.len;
                if (this.buf[this.off++] == '\"' && this.buf[this.off - 2] != '\\') break;
            }
            this.path.len -= 2;
            ++this.path.off;
            break block2;
            while (!this.terminal(this.buf[this.off])) {
                ++this.path.len;
                ++this.off;
lbl17:
                // 2 sources

                if (this.off < this.count) continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void domain() {
        block2: {
            this.domain.len = 0;
            if (!this.skip(";$Domain=")) break block2;
            this.domain.off = this.off;
            if (this.buf[this.off] != '\"') ** GOTO lbl17
            ++this.domain.len;
            ++this.off;
            while (this.off < this.count) {
                ++this.domain.len;
                if (this.buf[this.off++] == '\"' && this.buf[this.off - 2] != '\\') break;
            }
            this.domain.len -= 2;
            ++this.domain.off;
            break block2;
            while (!this.terminal(this.buf[this.off])) {
                ++this.domain.len;
                ++this.off;
lbl17:
                // 2 sources

                if (this.off < this.count) continue;
            }
        }
    }

    private void version() {
        if (this.skip("$Version=")) {
            if (this.buf[this.off] == '\"') {
                ++this.off;
            }
            while (this.off < this.count) {
                if (!this.digit(this.buf[this.off])) break;
                this.version *= 10;
                this.version += this.buf[this.off];
                this.version -= 48;
                ++this.off;
            }
            if (this.buf[this.off] == '\"') {
                ++this.off;
            }
        } else {
            this.version = 1;
        }
    }

    private boolean terminal(char c) {
        return c == ';' || c == ',';
    }

    private class Token
    implements Serializable {
        public transient int len;
        public transient int off;

        private Token() {
        }

        public String toString() {
            return new String(CookieParser.this.buf, this.off, this.len);
        }
    }
}

